// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Status information about the replication process, where you use the [ReplicateInstance](https://docs.aws.amazon.com/connect/latest/APIReference/API_ReplicateInstance.html) API to create a replica of your Amazon Connect instance in another Amazon Web Services Region. For more information, see [Set up Amazon Connect Global Resiliency](https://docs.aws.amazon.com/connect/latest/adminguide/setup-connect-global-resiliency.html) in the *Amazon Connect Administrator Guide*.
 */
public class ReplicationStatusSummary private constructor(builder: Builder) {
    /**
     * The Amazon Web Services Region. This can be either the source or the replica Region, depending where it appears in the summary list.
     */
    public val region: kotlin.String? = builder.region
    /**
     * The state of the replication.
     */
    public val replicationStatus: aws.sdk.kotlin.services.connect.model.InstanceReplicationStatus? = builder.replicationStatus
    /**
     * A description of the replication status. Use this information to resolve any issues that are preventing the successful replication of your Amazon Connect instance to another Region.
     */
    public val replicationStatusReason: kotlin.String? = builder.replicationStatusReason

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.ReplicationStatusSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReplicationStatusSummary(")
        append("region=$region,")
        append("replicationStatus=$replicationStatus,")
        append("replicationStatusReason=$replicationStatusReason")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = region?.hashCode() ?: 0
        result = 31 * result + (replicationStatus?.hashCode() ?: 0)
        result = 31 * result + (replicationStatusReason?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReplicationStatusSummary

        if (region != other.region) return false
        if (replicationStatus != other.replicationStatus) return false
        if (replicationStatusReason != other.replicationStatusReason) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.ReplicationStatusSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Web Services Region. This can be either the source or the replica Region, depending where it appears in the summary list.
         */
        public var region: kotlin.String? = null
        /**
         * The state of the replication.
         */
        public var replicationStatus: aws.sdk.kotlin.services.connect.model.InstanceReplicationStatus? = null
        /**
         * A description of the replication status. Use this information to resolve any issues that are preventing the successful replication of your Amazon Connect instance to another Region.
         */
        public var replicationStatusReason: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.ReplicationStatusSummary) : this() {
            this.region = x.region
            this.replicationStatus = x.replicationStatus
            this.replicationStatusReason = x.replicationStatusReason
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.ReplicationStatusSummary = ReplicationStatusSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
