// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Details about the status of the replication of a source Amazon Connect instance across Amazon Web Services Regions. Use these details to understand the general status of a given replication. For information about why a replication process may fail, see [Why a ReplicateInstance call fails](https://docs.aws.amazon.com/connect/latest/adminguide/create-replica-connect-instance.html#why-replicateinstance-fails) in the *Create a replica of your existing Amazon Connect instance* topic in the *Amazon Connect Administrator Guide*.
 */
public class ReplicationConfiguration private constructor(builder: Builder) {
    /**
     * The URL that is used to sign-in to your Amazon Connect instance according to your traffic distribution group configuration. For more information about sign-in and traffic distribution groups, see [Important things to know](https://docs.aws.amazon.com/connect/latest/adminguide/setup-traffic-distribution-groups.html) in the *Create traffic distribution groups* topic in the *Amazon Connect Administrator Guide*.
     */
    public val globalSignInEndpoint: kotlin.String? = builder.globalSignInEndpoint
    /**
     * A list of replication status summaries. The summaries contain details about the replication of configuration information for Amazon Connect resources, for each Amazon Web Services Region.
     */
    public val replicationStatusSummaryList: List<ReplicationStatusSummary>? = builder.replicationStatusSummaryList
    /**
     * The Amazon Web Services Region where the source Amazon Connect instance was created. This is the Region where the [ReplicateInstance](https://docs.aws.amazon.com/connect/latest/APIReference/API_ReplicateInstance.html) API was called to start the replication process.
     */
    public val sourceRegion: kotlin.String? = builder.sourceRegion

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.ReplicationConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReplicationConfiguration(")
        append("globalSignInEndpoint=$globalSignInEndpoint,")
        append("replicationStatusSummaryList=$replicationStatusSummaryList,")
        append("sourceRegion=$sourceRegion")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = globalSignInEndpoint?.hashCode() ?: 0
        result = 31 * result + (replicationStatusSummaryList?.hashCode() ?: 0)
        result = 31 * result + (sourceRegion?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReplicationConfiguration

        if (globalSignInEndpoint != other.globalSignInEndpoint) return false
        if (replicationStatusSummaryList != other.replicationStatusSummaryList) return false
        if (sourceRegion != other.sourceRegion) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.ReplicationConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The URL that is used to sign-in to your Amazon Connect instance according to your traffic distribution group configuration. For more information about sign-in and traffic distribution groups, see [Important things to know](https://docs.aws.amazon.com/connect/latest/adminguide/setup-traffic-distribution-groups.html) in the *Create traffic distribution groups* topic in the *Amazon Connect Administrator Guide*.
         */
        public var globalSignInEndpoint: kotlin.String? = null
        /**
         * A list of replication status summaries. The summaries contain details about the replication of configuration information for Amazon Connect resources, for each Amazon Web Services Region.
         */
        public var replicationStatusSummaryList: List<ReplicationStatusSummary>? = null
        /**
         * The Amazon Web Services Region where the source Amazon Connect instance was created. This is the Region where the [ReplicateInstance](https://docs.aws.amazon.com/connect/latest/APIReference/API_ReplicateInstance.html) API was called to start the replication process.
         */
        public var sourceRegion: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.ReplicationConfiguration) : this() {
            this.globalSignInEndpoint = x.globalSignInEndpoint
            this.replicationStatusSummaryList = x.replicationStatusSummaryList
            this.sourceRegion = x.sourceRegion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.ReplicationConfiguration = ReplicationConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
