// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about the post-contact summary for a real-time contact segment.
 */
public class RealTimeContactAnalysisSegmentPostContactSummary private constructor(builder: Builder) {
    /**
     * The content of the summary.
     */
    public val content: kotlin.String? = builder.content
    /**
     * If the summary failed to be generated, one of the following failure codes occurs:
     * + `QUOTA_EXCEEDED`: The number of concurrent analytics jobs reached your service quota.
     * + `INSUFFICIENT_CONVERSATION_CONTENT`: The conversation needs to have at least one turn from both the participants in order to generate the summary.
     * + `FAILED_SAFETY_GUIDELINES`: The generated summary cannot be provided because it failed to meet system safety guidelines.
     * + `INVALID_ANALYSIS_CONFIGURATION`: This code occurs when, for example, you're using a [language](https://docs.aws.amazon.com/connect/latest/adminguide/supported-languages.html#supported-languages-contact-lens) that isn't supported by generative AI-powered post-contact summaries.
     * + `INTERNAL_ERROR`: Internal system error.
     */
    public val failureCode: aws.sdk.kotlin.services.connect.model.RealTimeContactAnalysisPostContactSummaryFailureCode? = builder.failureCode
    /**
     * Whether the summary was successfully COMPLETED or FAILED to be generated.
     */
    public val status: aws.sdk.kotlin.services.connect.model.RealTimeContactAnalysisPostContactSummaryStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.RealTimeContactAnalysisSegmentPostContactSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RealTimeContactAnalysisSegmentPostContactSummary(")
        append("content=$content,")
        append("failureCode=$failureCode,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = content?.hashCode() ?: 0
        result = 31 * result + (failureCode?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RealTimeContactAnalysisSegmentPostContactSummary

        if (content != other.content) return false
        if (failureCode != other.failureCode) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.RealTimeContactAnalysisSegmentPostContactSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The content of the summary.
         */
        public var content: kotlin.String? = null
        /**
         * If the summary failed to be generated, one of the following failure codes occurs:
         * + `QUOTA_EXCEEDED`: The number of concurrent analytics jobs reached your service quota.
         * + `INSUFFICIENT_CONVERSATION_CONTENT`: The conversation needs to have at least one turn from both the participants in order to generate the summary.
         * + `FAILED_SAFETY_GUIDELINES`: The generated summary cannot be provided because it failed to meet system safety guidelines.
         * + `INVALID_ANALYSIS_CONFIGURATION`: This code occurs when, for example, you're using a [language](https://docs.aws.amazon.com/connect/latest/adminguide/supported-languages.html#supported-languages-contact-lens) that isn't supported by generative AI-powered post-contact summaries.
         * + `INTERNAL_ERROR`: Internal system error.
         */
        public var failureCode: aws.sdk.kotlin.services.connect.model.RealTimeContactAnalysisPostContactSummaryFailureCode? = null
        /**
         * Whether the summary was successfully COMPLETED or FAILED to be generated.
         */
        public var status: aws.sdk.kotlin.services.connect.model.RealTimeContactAnalysisPostContactSummaryStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.RealTimeContactAnalysisSegmentPostContactSummary) : this() {
            this.content = x.content
            this.failureCode = x.failureCode
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.RealTimeContactAnalysisSegmentPostContactSummary = RealTimeContactAnalysisSegmentPostContactSummary(this)

        internal fun correctErrors(): Builder {
            if (status == null) status = RealTimeContactAnalysisPostContactSummaryStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
