// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains information about the filter used when retrieving metrics. `MetricFiltersV2` can be used on the following metrics: `AVG_AGENT_CONNECTING_TIME`, `CONTACTS_CREATED`, `CONTACTS_HANDLED`, `SUM_CONTACTS_DISCONNECTED`.
 */
public class MetricFilterV2 private constructor(builder: Builder) {
    /**
     * The key to use for filtering data.
     *
     * Valid metric filter keys:
     * + ANSWERING_MACHINE_DETECTION_STATUS
     * + CASE_STATUS
     * + DISCONNECT_REASON
     * + FLOWS_ACTION_IDENTIFIER
     * + FLOWS_NEXT_ACTION_IDENTIFIER
     * + FLOWS_OUTCOME_TYPE
     * + FLOWS_RESOURCE_TYPE
     * + INITIATION_METHOD
     */
    public val metricFilterKey: kotlin.String? = builder.metricFilterKey
    /**
     * The values to use for filtering data. Values for metric-level filters can be either a fixed set of values or a customized list, depending on the use case.
     *
     * For valid values of metric-level filters `INITIATION_METHOD`, `DISCONNECT_REASON`, and `ANSWERING_MACHINE_DETECTION_STATUS`, see [ContactTraceRecord](https://docs.aws.amazon.com/connect/latest/adminguide/ctr-data-model.html#ctr-ContactTraceRecord) in the *Amazon Connect Administrator Guide*.
     *
     * For valid values of the metric-level filter `FLOWS_OUTCOME_TYPE`, see the description for the [Flow outcome](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#flows-outcome-historical) metric in the *Amazon Connect Administrator Guide*.
     *
     * For valid values of the metric-level filter `BOT_CONVERSATION_OUTCOME_TYPE`, see the description for the [Bot conversations completed](https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#bot-conversations-completed-metric) in the *Amazon Connect Administrator Guide*.
     *
     * For valid values of the metric-level filter `BOT_INTENT_OUTCOME_TYPE`, see the description for the [Bot intents completed](https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#bot-intents-completed-metric) metric in the *Amazon Connect Administrator Guide*.
     */
    public val metricFilterValues: List<String>? = builder.metricFilterValues
    /**
     * If set to `true`, the API response contains results that filter out the results matched by the metric-level filters condition. By default, `Negate` is set to `false`.
     */
    public val negate: kotlin.Boolean = builder.negate

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.MetricFilterV2 = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MetricFilterV2(")
        append("metricFilterKey=$metricFilterKey,")
        append("metricFilterValues=$metricFilterValues,")
        append("negate=$negate")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = metricFilterKey?.hashCode() ?: 0
        result = 31 * result + (metricFilterValues?.hashCode() ?: 0)
        result = 31 * result + (negate.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MetricFilterV2

        if (metricFilterKey != other.metricFilterKey) return false
        if (metricFilterValues != other.metricFilterValues) return false
        if (negate != other.negate) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.MetricFilterV2 = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The key to use for filtering data.
         *
         * Valid metric filter keys:
         * + ANSWERING_MACHINE_DETECTION_STATUS
         * + CASE_STATUS
         * + DISCONNECT_REASON
         * + FLOWS_ACTION_IDENTIFIER
         * + FLOWS_NEXT_ACTION_IDENTIFIER
         * + FLOWS_OUTCOME_TYPE
         * + FLOWS_RESOURCE_TYPE
         * + INITIATION_METHOD
         */
        public var metricFilterKey: kotlin.String? = null
        /**
         * The values to use for filtering data. Values for metric-level filters can be either a fixed set of values or a customized list, depending on the use case.
         *
         * For valid values of metric-level filters `INITIATION_METHOD`, `DISCONNECT_REASON`, and `ANSWERING_MACHINE_DETECTION_STATUS`, see [ContactTraceRecord](https://docs.aws.amazon.com/connect/latest/adminguide/ctr-data-model.html#ctr-ContactTraceRecord) in the *Amazon Connect Administrator Guide*.
         *
         * For valid values of the metric-level filter `FLOWS_OUTCOME_TYPE`, see the description for the [Flow outcome](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#flows-outcome-historical) metric in the *Amazon Connect Administrator Guide*.
         *
         * For valid values of the metric-level filter `BOT_CONVERSATION_OUTCOME_TYPE`, see the description for the [Bot conversations completed](https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#bot-conversations-completed-metric) in the *Amazon Connect Administrator Guide*.
         *
         * For valid values of the metric-level filter `BOT_INTENT_OUTCOME_TYPE`, see the description for the [Bot intents completed](https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#bot-intents-completed-metric) metric in the *Amazon Connect Administrator Guide*.
         */
        public var metricFilterValues: List<String>? = null
        /**
         * If set to `true`, the API response contains results that filter out the results matched by the metric-level filters condition. By default, `Negate` is set to `false`.
         */
        public var negate: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.MetricFilterV2) : this() {
            this.metricFilterKey = x.metricFilterKey
            this.metricFilterValues = x.metricFilterValues
            this.negate = x.negate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.MetricFilterV2 = MetricFilterV2(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
