// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about phone numbers that have been claimed to your Amazon Connect instance or traffic distribution group.
 */
public class ListPhoneNumbersSummary private constructor(builder: Builder) {
    /**
     * The identifier of the Amazon Connect instance that phone numbers are claimed to. You can [find the instance ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html) in the Amazon Resource Name (ARN) of the instance.
     */
    public val instanceId: kotlin.String? = builder.instanceId
    /**
     * The phone number. Phone numbers are formatted `[+] [country code] [subscriber number including area code]`.
     */
    public val phoneNumber: kotlin.String? = builder.phoneNumber
    /**
     * The Amazon Resource Name (ARN) of the phone number.
     */
    public val phoneNumberArn: kotlin.String? = builder.phoneNumberArn
    /**
     * The ISO country code.
     */
    public val phoneNumberCountryCode: aws.sdk.kotlin.services.connect.model.PhoneNumberCountryCode? = builder.phoneNumberCountryCode
    /**
     * The description of the phone number.
     */
    public val phoneNumberDescription: kotlin.String? = builder.phoneNumberDescription
    /**
     * A unique identifier for the phone number.
     */
    public val phoneNumberId: kotlin.String? = builder.phoneNumberId
    /**
     * The type of phone number.
     */
    public val phoneNumberType: aws.sdk.kotlin.services.connect.model.PhoneNumberType? = builder.phoneNumberType
    /**
     * The claimed phone number ARN that was previously imported from the external service, such as Amazon Web Services End User Messaging. If it is from Amazon Web Services End User Messaging, it looks like the ARN of the phone number that was imported from Amazon Web Services End User Messaging.
     */
    public val sourcePhoneNumberArn: kotlin.String? = builder.sourcePhoneNumberArn
    /**
     * The Amazon Resource Name (ARN) for Amazon Connect instances or traffic distribution groups that phone number inbound traffic is routed through.
     */
    public val targetArn: kotlin.String? = builder.targetArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.ListPhoneNumbersSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListPhoneNumbersSummary(")
        append("instanceId=$instanceId,")
        append("phoneNumber=$phoneNumber,")
        append("phoneNumberArn=$phoneNumberArn,")
        append("phoneNumberCountryCode=$phoneNumberCountryCode,")
        append("phoneNumberDescription=$phoneNumberDescription,")
        append("phoneNumberId=$phoneNumberId,")
        append("phoneNumberType=$phoneNumberType,")
        append("sourcePhoneNumberArn=$sourcePhoneNumberArn,")
        append("targetArn=$targetArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = instanceId?.hashCode() ?: 0
        result = 31 * result + (phoneNumber?.hashCode() ?: 0)
        result = 31 * result + (phoneNumberArn?.hashCode() ?: 0)
        result = 31 * result + (phoneNumberCountryCode?.hashCode() ?: 0)
        result = 31 * result + (phoneNumberDescription?.hashCode() ?: 0)
        result = 31 * result + (phoneNumberId?.hashCode() ?: 0)
        result = 31 * result + (phoneNumberType?.hashCode() ?: 0)
        result = 31 * result + (sourcePhoneNumberArn?.hashCode() ?: 0)
        result = 31 * result + (targetArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListPhoneNumbersSummary

        if (instanceId != other.instanceId) return false
        if (phoneNumber != other.phoneNumber) return false
        if (phoneNumberArn != other.phoneNumberArn) return false
        if (phoneNumberCountryCode != other.phoneNumberCountryCode) return false
        if (phoneNumberDescription != other.phoneNumberDescription) return false
        if (phoneNumberId != other.phoneNumberId) return false
        if (phoneNumberType != other.phoneNumberType) return false
        if (sourcePhoneNumberArn != other.sourcePhoneNumberArn) return false
        if (targetArn != other.targetArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.ListPhoneNumbersSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier of the Amazon Connect instance that phone numbers are claimed to. You can [find the instance ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html) in the Amazon Resource Name (ARN) of the instance.
         */
        public var instanceId: kotlin.String? = null
        /**
         * The phone number. Phone numbers are formatted `[+] [country code] [subscriber number including area code]`.
         */
        public var phoneNumber: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the phone number.
         */
        public var phoneNumberArn: kotlin.String? = null
        /**
         * The ISO country code.
         */
        public var phoneNumberCountryCode: aws.sdk.kotlin.services.connect.model.PhoneNumberCountryCode? = null
        /**
         * The description of the phone number.
         */
        public var phoneNumberDescription: kotlin.String? = null
        /**
         * A unique identifier for the phone number.
         */
        public var phoneNumberId: kotlin.String? = null
        /**
         * The type of phone number.
         */
        public var phoneNumberType: aws.sdk.kotlin.services.connect.model.PhoneNumberType? = null
        /**
         * The claimed phone number ARN that was previously imported from the external service, such as Amazon Web Services End User Messaging. If it is from Amazon Web Services End User Messaging, it looks like the ARN of the phone number that was imported from Amazon Web Services End User Messaging.
         */
        public var sourcePhoneNumberArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for Amazon Connect instances or traffic distribution groups that phone number inbound traffic is routed through.
         */
        public var targetArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.ListPhoneNumbersSummary) : this() {
            this.instanceId = x.instanceId
            this.phoneNumber = x.phoneNumber
            this.phoneNumberArn = x.phoneNumberArn
            this.phoneNumberCountryCode = x.phoneNumberCountryCode
            this.phoneNumberDescription = x.phoneNumberDescription
            this.phoneNumberId = x.phoneNumberId
            this.phoneNumberType = x.phoneNumberType
            this.sourcePhoneNumberArn = x.sourcePhoneNumberArn
            this.targetArn = x.targetArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.ListPhoneNumbersSummary = ListPhoneNumbersSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
