// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ListPhoneNumbersRequest private constructor(builder: Builder) {
    /**
     * The identifier of the Amazon Connect instance. You can [find the instance ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html) in the Amazon Resource Name (ARN) of the instance.
     */
    public val instanceId: kotlin.String? = builder.instanceId
    /**
     * The maximum number of results to return per page. The default MaxResult size is 100.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The ISO country code.
     */
    public val phoneNumberCountryCodes: List<PhoneNumberCountryCode>? = builder.phoneNumberCountryCodes
    /**
     * The type of phone number.
     *
     * We recommend using [ListPhoneNumbersV2](https://docs.aws.amazon.com/connect/latest/APIReference/API_ListPhoneNumbersV2.html) to return phone number types. While ListPhoneNumbers returns number types `UIFN`, `SHARED`, `THIRD_PARTY_TF`, and `THIRD_PARTY_DID`, it incorrectly lists them as `TOLL_FREE` or `DID`.
     */
    public val phoneNumberTypes: List<PhoneNumberType>? = builder.phoneNumberTypes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.ListPhoneNumbersRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListPhoneNumbersRequest(")
        append("instanceId=$instanceId,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("phoneNumberCountryCodes=$phoneNumberCountryCodes,")
        append("phoneNumberTypes=$phoneNumberTypes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = instanceId?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (phoneNumberCountryCodes?.hashCode() ?: 0)
        result = 31 * result + (phoneNumberTypes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListPhoneNumbersRequest

        if (instanceId != other.instanceId) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (phoneNumberCountryCodes != other.phoneNumberCountryCodes) return false
        if (phoneNumberTypes != other.phoneNumberTypes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.ListPhoneNumbersRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier of the Amazon Connect instance. You can [find the instance ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html) in the Amazon Resource Name (ARN) of the instance.
         */
        public var instanceId: kotlin.String? = null
        /**
         * The maximum number of results to return per page. The default MaxResult size is 100.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The ISO country code.
         */
        public var phoneNumberCountryCodes: List<PhoneNumberCountryCode>? = null
        /**
         * The type of phone number.
         *
         * We recommend using [ListPhoneNumbersV2](https://docs.aws.amazon.com/connect/latest/APIReference/API_ListPhoneNumbersV2.html) to return phone number types. While ListPhoneNumbers returns number types `UIFN`, `SHARED`, `THIRD_PARTY_TF`, and `THIRD_PARTY_DID`, it incorrectly lists them as `TOLL_FREE` or `DID`.
         */
        public var phoneNumberTypes: List<PhoneNumberType>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.ListPhoneNumbersRequest) : this() {
            this.instanceId = x.instanceId
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.phoneNumberCountryCodes = x.phoneNumberCountryCodes
            this.phoneNumberTypes = x.phoneNumberTypes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.ListPhoneNumbersRequest = ListPhoneNumbersRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
