// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Configuration information of a Kinesis video stream.
 */
public class KinesisVideoStreamConfig private constructor(builder: Builder) {
    /**
     * The encryption configuration.
     */
    public val encryptionConfig: aws.sdk.kotlin.services.connect.model.EncryptionConfig? = builder.encryptionConfig
    /**
     * The prefix of the video stream.
     */
    public val prefix: kotlin.String = requireNotNull(builder.prefix) { "A non-null value must be provided for prefix" }
    /**
     * The number of hours data is retained in the stream. Kinesis Video Streams retains the data in a data store that is associated with the stream.
     *
     * The default value is 0, indicating that the stream does not persist data.
     */
    public val retentionPeriodHours: kotlin.Int = builder.retentionPeriodHours

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.KinesisVideoStreamConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KinesisVideoStreamConfig(")
        append("encryptionConfig=$encryptionConfig,")
        append("prefix=$prefix,")
        append("retentionPeriodHours=$retentionPeriodHours")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = encryptionConfig?.hashCode() ?: 0
        result = 31 * result + (prefix.hashCode())
        result = 31 * result + (retentionPeriodHours)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as KinesisVideoStreamConfig

        if (encryptionConfig != other.encryptionConfig) return false
        if (prefix != other.prefix) return false
        if (retentionPeriodHours != other.retentionPeriodHours) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.KinesisVideoStreamConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The encryption configuration.
         */
        public var encryptionConfig: aws.sdk.kotlin.services.connect.model.EncryptionConfig? = null
        /**
         * The prefix of the video stream.
         */
        public var prefix: kotlin.String? = null
        /**
         * The number of hours data is retained in the stream. Kinesis Video Streams retains the data in a data store that is associated with the stream.
         *
         * The default value is 0, indicating that the stream does not persist data.
         */
        public var retentionPeriodHours: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.KinesisVideoStreamConfig) : this() {
            this.encryptionConfig = x.encryptionConfig
            this.prefix = x.prefix
            this.retentionPeriodHours = x.retentionPeriodHours
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.KinesisVideoStreamConfig = KinesisVideoStreamConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.EncryptionConfig] inside the given [block]
         */
        public fun encryptionConfig(block: aws.sdk.kotlin.services.connect.model.EncryptionConfig.Builder.() -> kotlin.Unit) {
            this.encryptionConfig = aws.sdk.kotlin.services.connect.model.EncryptionConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (prefix == null) prefix = ""
            return this
        }
    }
}
