// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about the interval period to use for returning results.
 */
public class IntervalDetails private constructor(builder: Builder) {
    /**
     * `IntervalPeriod`: An aggregated grouping applied to request metrics. Valid `IntervalPeriod` values are: `FIFTEEN_MIN` | `THIRTY_MIN` | `HOUR` | `DAY` | `WEEK` | `TOTAL`.
     *
     * For example, if `IntervalPeriod` is selected `THIRTY_MIN`, `StartTime` and `EndTime` differs by 1 day, then Amazon Connect returns 48 results in the response. Each result is aggregated by the THIRTY_MIN period. By default Amazon Connect aggregates results based on the `TOTAL` interval period.
     *
     * The following list describes restrictions on `StartTime` and `EndTime` based on what `IntervalPeriod` is requested.
     * + `FIFTEEN_MIN`: The difference between `StartTime` and `EndTime` must be less than 3 days.
     * + `THIRTY_MIN`: The difference between `StartTime` and `EndTime` must be less than 3 days.
     * + `HOUR`: The difference between `StartTime` and `EndTime` must be less than 3 days.
     * + `DAY`: The difference between `StartTime` and `EndTime` must be less than 35 days.
     * + `WEEK`: The difference between `StartTime` and `EndTime` must be less than 35 days.
     * + `TOTAL`: The difference between `StartTime` and `EndTime` must be less than 35 days.
     */
    public val intervalPeriod: aws.sdk.kotlin.services.connect.model.IntervalPeriod? = builder.intervalPeriod
    /**
     * The timezone applied to requested metrics.
     */
    public val timeZone: kotlin.String? = builder.timeZone

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.IntervalDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IntervalDetails(")
        append("intervalPeriod=$intervalPeriod,")
        append("timeZone=$timeZone")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = intervalPeriod?.hashCode() ?: 0
        result = 31 * result + (timeZone?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IntervalDetails

        if (intervalPeriod != other.intervalPeriod) return false
        if (timeZone != other.timeZone) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.IntervalDetails = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * `IntervalPeriod`: An aggregated grouping applied to request metrics. Valid `IntervalPeriod` values are: `FIFTEEN_MIN` | `THIRTY_MIN` | `HOUR` | `DAY` | `WEEK` | `TOTAL`.
         *
         * For example, if `IntervalPeriod` is selected `THIRTY_MIN`, `StartTime` and `EndTime` differs by 1 day, then Amazon Connect returns 48 results in the response. Each result is aggregated by the THIRTY_MIN period. By default Amazon Connect aggregates results based on the `TOTAL` interval period.
         *
         * The following list describes restrictions on `StartTime` and `EndTime` based on what `IntervalPeriod` is requested.
         * + `FIFTEEN_MIN`: The difference between `StartTime` and `EndTime` must be less than 3 days.
         * + `THIRTY_MIN`: The difference between `StartTime` and `EndTime` must be less than 3 days.
         * + `HOUR`: The difference between `StartTime` and `EndTime` must be less than 3 days.
         * + `DAY`: The difference between `StartTime` and `EndTime` must be less than 35 days.
         * + `WEEK`: The difference between `StartTime` and `EndTime` must be less than 35 days.
         * + `TOTAL`: The difference between `StartTime` and `EndTime` must be less than 35 days.
         */
        public var intervalPeriod: aws.sdk.kotlin.services.connect.model.IntervalPeriod? = null
        /**
         * The timezone applied to requested metrics.
         */
        public var timeZone: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.IntervalDetails) : this() {
            this.intervalPeriod = x.intervalPeriod
            this.timeZone = x.timeZone
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.IntervalDetails = IntervalDetails(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
