// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about the raw email body content.
 */
public class InboundRawMessage private constructor(builder: Builder) {
    /**
     * The email message body.
     */
    public val body: kotlin.String = requireNotNull(builder.body) { "A non-null value must be provided for body" }
    /**
     * Type of content, that is, `text/plain` or `text/html`.
     */
    public val contentType: kotlin.String = requireNotNull(builder.contentType) { "A non-null value must be provided for contentType" }
    /**
     * Headers present in inbound email.
     */
    public val headers: Map<EmailHeaderType, String>? = builder.headers
    /**
     * The email subject.
     */
    public val subject: kotlin.String = requireNotNull(builder.subject) { "A non-null value must be provided for subject" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.InboundRawMessage = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InboundRawMessage(")
        append("body=*** Sensitive Data Redacted ***,")
        append("contentType=$contentType,")
        append("headers=$headers,")
        append("subject=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = body.hashCode()
        result = 31 * result + (contentType.hashCode())
        result = 31 * result + (headers?.hashCode() ?: 0)
        result = 31 * result + (subject.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InboundRawMessage

        if (body != other.body) return false
        if (contentType != other.contentType) return false
        if (headers != other.headers) return false
        if (subject != other.subject) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.InboundRawMessage = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The email message body.
         */
        public var body: kotlin.String? = null
        /**
         * Type of content, that is, `text/plain` or `text/html`.
         */
        public var contentType: kotlin.String? = null
        /**
         * Headers present in inbound email.
         */
        public var headers: Map<EmailHeaderType, String>? = null
        /**
         * The email subject.
         */
        public var subject: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.InboundRawMessage) : this() {
            this.body = x.body
            this.contentType = x.contentType
            this.headers = x.headers
            this.subject = x.subject
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.InboundRawMessage = InboundRawMessage(this)

        internal fun correctErrors(): Builder {
            if (body == null) body = ""
            if (contentType == null) contentType = ""
            if (subject == null) subject = ""
            return this
        }
    }
}
