// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about the evaluation form.
 */
public class EvaluationForm private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the user who created the evaluation form.
     */
    public val createdBy: kotlin.String = requireNotNull(builder.createdBy) { "A non-null value must be provided for createdBy" }
    /**
     * The timestamp for when the evaluation form was created.
     */
    public val createdTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdTime) { "A non-null value must be provided for createdTime" }
    /**
     * The description of the evaluation form.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The Amazon Resource Name (ARN) for the evaluation form resource.
     */
    public val evaluationFormArn: kotlin.String = requireNotNull(builder.evaluationFormArn) { "A non-null value must be provided for evaluationFormArn" }
    /**
     * The unique identifier for the evaluation form.
     */
    public val evaluationFormId: kotlin.String = requireNotNull(builder.evaluationFormId) { "A non-null value must be provided for evaluationFormId" }
    /**
     * A version of the evaluation form.
     */
    public val evaluationFormVersion: kotlin.Int = builder.evaluationFormVersion
    /**
     * Items that are part of the evaluation form. The total number of sections and questions must not exceed 100 each. Questions must be contained in a section.
     */
    public val items: List<EvaluationFormItem> = requireNotNull(builder.items) { "A non-null value must be provided for items" }
    /**
     * The Amazon Resource Name (ARN) of the user who last updated the evaluation form.
     */
    public val lastModifiedBy: kotlin.String = requireNotNull(builder.lastModifiedBy) { "A non-null value must be provided for lastModifiedBy" }
    /**
     * The timestamp for when the evaluation form was last updated.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastModifiedTime) { "A non-null value must be provided for lastModifiedTime" }
    /**
     * The flag indicating whether the evaluation form is locked for changes.
     */
    public val locked: kotlin.Boolean = builder.locked
    /**
     * A scoring strategy of the evaluation form.
     */
    public val scoringStrategy: aws.sdk.kotlin.services.connect.model.EvaluationFormScoringStrategy? = builder.scoringStrategy
    /**
     * The status of the evaluation form.
     */
    public val status: aws.sdk.kotlin.services.connect.model.EvaluationFormVersionStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * A title of the evaluation form.
     */
    public val title: kotlin.String = requireNotNull(builder.title) { "A non-null value must be provided for title" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.EvaluationForm = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EvaluationForm(")
        append("createdBy=$createdBy,")
        append("createdTime=$createdTime,")
        append("description=$description,")
        append("evaluationFormArn=$evaluationFormArn,")
        append("evaluationFormId=$evaluationFormId,")
        append("evaluationFormVersion=$evaluationFormVersion,")
        append("items=$items,")
        append("lastModifiedBy=$lastModifiedBy,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("locked=$locked,")
        append("scoringStrategy=$scoringStrategy,")
        append("status=$status,")
        append("tags=$tags,")
        append("title=$title")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdBy.hashCode()
        result = 31 * result + (createdTime.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (evaluationFormArn.hashCode())
        result = 31 * result + (evaluationFormId.hashCode())
        result = 31 * result + (evaluationFormVersion)
        result = 31 * result + (items.hashCode())
        result = 31 * result + (lastModifiedBy.hashCode())
        result = 31 * result + (lastModifiedTime.hashCode())
        result = 31 * result + (locked.hashCode())
        result = 31 * result + (scoringStrategy?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (title.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EvaluationForm

        if (createdBy != other.createdBy) return false
        if (createdTime != other.createdTime) return false
        if (description != other.description) return false
        if (evaluationFormArn != other.evaluationFormArn) return false
        if (evaluationFormId != other.evaluationFormId) return false
        if (evaluationFormVersion != other.evaluationFormVersion) return false
        if (items != other.items) return false
        if (lastModifiedBy != other.lastModifiedBy) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (locked != other.locked) return false
        if (scoringStrategy != other.scoringStrategy) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (title != other.title) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.EvaluationForm = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the user who created the evaluation form.
         */
        public var createdBy: kotlin.String? = null
        /**
         * The timestamp for when the evaluation form was created.
         */
        public var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the evaluation form.
         */
        public var description: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for the evaluation form resource.
         */
        public var evaluationFormArn: kotlin.String? = null
        /**
         * The unique identifier for the evaluation form.
         */
        public var evaluationFormId: kotlin.String? = null
        /**
         * A version of the evaluation form.
         */
        public var evaluationFormVersion: kotlin.Int = 0
        /**
         * Items that are part of the evaluation form. The total number of sections and questions must not exceed 100 each. Questions must be contained in a section.
         */
        public var items: List<EvaluationFormItem>? = null
        /**
         * The Amazon Resource Name (ARN) of the user who last updated the evaluation form.
         */
        public var lastModifiedBy: kotlin.String? = null
        /**
         * The timestamp for when the evaluation form was last updated.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The flag indicating whether the evaluation form is locked for changes.
         */
        public var locked: kotlin.Boolean = false
        /**
         * A scoring strategy of the evaluation form.
         */
        public var scoringStrategy: aws.sdk.kotlin.services.connect.model.EvaluationFormScoringStrategy? = null
        /**
         * The status of the evaluation form.
         */
        public var status: aws.sdk.kotlin.services.connect.model.EvaluationFormVersionStatus? = null
        /**
         * The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.
         */
        public var tags: Map<String, String>? = null
        /**
         * A title of the evaluation form.
         */
        public var title: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.EvaluationForm) : this() {
            this.createdBy = x.createdBy
            this.createdTime = x.createdTime
            this.description = x.description
            this.evaluationFormArn = x.evaluationFormArn
            this.evaluationFormId = x.evaluationFormId
            this.evaluationFormVersion = x.evaluationFormVersion
            this.items = x.items
            this.lastModifiedBy = x.lastModifiedBy
            this.lastModifiedTime = x.lastModifiedTime
            this.locked = x.locked
            this.scoringStrategy = x.scoringStrategy
            this.status = x.status
            this.tags = x.tags
            this.title = x.title
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.EvaluationForm = EvaluationForm(this)

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.EvaluationFormScoringStrategy] inside the given [block]
         */
        public fun scoringStrategy(block: aws.sdk.kotlin.services.connect.model.EvaluationFormScoringStrategy.Builder.() -> kotlin.Unit) {
            this.scoringStrategy = aws.sdk.kotlin.services.connect.model.EvaluationFormScoringStrategy.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (createdBy == null) createdBy = ""
            if (createdTime == null) createdTime = Instant.fromEpochSeconds(0)
            if (evaluationFormArn == null) evaluationFormArn = ""
            if (evaluationFormId == null) evaluationFormId = ""
            if (items == null) items = emptyList()
            if (lastModifiedBy == null) lastModifiedBy = ""
            if (lastModifiedTime == null) lastModifiedTime = Instant.fromEpochSeconds(0)
            if (status == null) status = EvaluationFormVersionStatus.SdkUnknown("no value provided")
            if (title == null) title = ""
            return this
        }
    }
}
