// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateRoutingProfileRequest private constructor(builder: Builder) {
    /**
     * Whether agents with this routing profile will have their routing order calculated based on *longest idle time* or *time since their last inbound contact*.
     */
    public val agentAvailabilityTimer: aws.sdk.kotlin.services.connect.model.AgentAvailabilityTimer? = builder.agentAvailabilityTimer
    /**
     * The default outbound queue for the routing profile.
     */
    public val defaultOutboundQueueId: kotlin.String? = builder.defaultOutboundQueueId
    /**
     * Description of the routing profile. Must not be more than 250 characters.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The identifier of the Amazon Connect instance. You can [find the instance ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html) in the Amazon Resource Name (ARN) of the instance.
     */
    public val instanceId: kotlin.String? = builder.instanceId
    /**
     * The channels that agents can handle in the Contact Control Panel (CCP) for this routing profile.
     */
    public val mediaConcurrencies: List<MediaConcurrency>? = builder.mediaConcurrencies
    /**
     * The name of the routing profile. Must not be more than 127 characters.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The inbound queues associated with the routing profile. If no queue is added, the agent can make only outbound calls.
     *
     * The limit of 10 array members applies to the maximum number of `RoutingProfileQueueConfig` objects that can be passed during a CreateRoutingProfile API request. It is different from the quota of 50 queues per routing profile per instance that is listed in [Amazon Connect service quotas](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html).
     */
    public val queueConfigs: List<RoutingProfileQueueConfig>? = builder.queueConfigs
    /**
     * The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.CreateRoutingProfileRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateRoutingProfileRequest(")
        append("agentAvailabilityTimer=$agentAvailabilityTimer,")
        append("defaultOutboundQueueId=$defaultOutboundQueueId,")
        append("description=$description,")
        append("instanceId=$instanceId,")
        append("mediaConcurrencies=$mediaConcurrencies,")
        append("name=$name,")
        append("queueConfigs=$queueConfigs,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = agentAvailabilityTimer?.hashCode() ?: 0
        result = 31 * result + (defaultOutboundQueueId?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (mediaConcurrencies?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (queueConfigs?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateRoutingProfileRequest

        if (agentAvailabilityTimer != other.agentAvailabilityTimer) return false
        if (defaultOutboundQueueId != other.defaultOutboundQueueId) return false
        if (description != other.description) return false
        if (instanceId != other.instanceId) return false
        if (mediaConcurrencies != other.mediaConcurrencies) return false
        if (name != other.name) return false
        if (queueConfigs != other.queueConfigs) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.CreateRoutingProfileRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Whether agents with this routing profile will have their routing order calculated based on *longest idle time* or *time since their last inbound contact*.
         */
        public var agentAvailabilityTimer: aws.sdk.kotlin.services.connect.model.AgentAvailabilityTimer? = null
        /**
         * The default outbound queue for the routing profile.
         */
        public var defaultOutboundQueueId: kotlin.String? = null
        /**
         * Description of the routing profile. Must not be more than 250 characters.
         */
        public var description: kotlin.String? = null
        /**
         * The identifier of the Amazon Connect instance. You can [find the instance ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html) in the Amazon Resource Name (ARN) of the instance.
         */
        public var instanceId: kotlin.String? = null
        /**
         * The channels that agents can handle in the Contact Control Panel (CCP) for this routing profile.
         */
        public var mediaConcurrencies: List<MediaConcurrency>? = null
        /**
         * The name of the routing profile. Must not be more than 127 characters.
         */
        public var name: kotlin.String? = null
        /**
         * The inbound queues associated with the routing profile. If no queue is added, the agent can make only outbound calls.
         *
         * The limit of 10 array members applies to the maximum number of `RoutingProfileQueueConfig` objects that can be passed during a CreateRoutingProfile API request. It is different from the quota of 50 queues per routing profile per instance that is listed in [Amazon Connect service quotas](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html).
         */
        public var queueConfigs: List<RoutingProfileQueueConfig>? = null
        /**
         * The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.CreateRoutingProfileRequest) : this() {
            this.agentAvailabilityTimer = x.agentAvailabilityTimer
            this.defaultOutboundQueueId = x.defaultOutboundQueueId
            this.description = x.description
            this.instanceId = x.instanceId
            this.mediaConcurrencies = x.mediaConcurrencies
            this.name = x.name
            this.queueConfigs = x.queueConfigs
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.CreateRoutingProfileRequest = CreateRoutingProfileRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
