// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateContactRequest private constructor(builder: Builder) {
    /**
     * A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes, and can be accessed in flows just like any other contact attributes.
     *
     * There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only alphanumeric, dash, and underscore characters.
     */
    public val attributes: Map<String, String>? = builder.attributes
    /**
     * The channel for the contact
     *
     * CreateContact only supports the EMAIL channel. The following information that states other channels are supported is incorrect. We are working to update this topic.
     */
    public val channel: aws.sdk.kotlin.services.connect.model.Channel? = builder.channel
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see [Making retries safe with idempotent APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * A description of the contact.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Number of minutes the contact will be active for before expiring
     */
    public val expiryDurationInMinutes: kotlin.Int? = builder.expiryDurationInMinutes
    /**
     * Initial state of the contact when it's created
     */
    public val initiateAs: aws.sdk.kotlin.services.connect.model.InitiateAs? = builder.initiateAs
    /**
     * Indicates how the contact was initiated.
     *
     * CreateContact only supports the following initiation methods: OUTBOUND, AGENT_REPLY, and FLOW. The following information that states other initiation methods are supported is incorrect. We are working to update this topic.
     */
    public val initiationMethod: aws.sdk.kotlin.services.connect.model.ContactInitiationMethod? = builder.initiationMethod
    /**
     * The identifier of the Amazon Connect instance. You can [find the instance ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html) in the Amazon Resource Name (ARN) of the instance.
     */
    public val instanceId: kotlin.String? = builder.instanceId
    /**
     * The name of a the contact.
     */
    public val name: kotlin.String? = builder.name
    /**
     * A formatted URL that is shown to an agent in the Contact Control Panel (CCP). Tasks can have the following reference types at the time of creation: URL | NUMBER | STRING | DATE | EMAIL | ATTACHMENT.
     */
    public val references: Map<String, Reference>? = builder.references
    /**
     * The identifier of the contact in this instance of Amazon Connect.
     */
    public val relatedContactId: kotlin.String? = builder.relatedContactId
    /**
     * A set of system defined key-value pairs stored on individual contact segments (unique contact ID) using an attribute map. The attributes are standard Amazon Connect attributes. They can be accessed in flows.
     *
     * Attribute keys can include only alphanumeric, -, and _.
     *
     * This field can be used to set Segment Contact Expiry as a duration in minutes.
     *
     * To set contact expiry, a ValueMap must be specified containing the integer number of minutes the contact will be active for before expiring, with `SegmentAttributes` like { ` "connect:ContactExpiry": {"ValueMap" : { "ExpiryDuration": { "ValueInteger": 135}}}}`.
     */
    public val segmentAttributes: Map<String, SegmentAttributeValue>? = builder.segmentAttributes
    /**
     * User details for the contact
     */
    public val userInfo: aws.sdk.kotlin.services.connect.model.UserInfo? = builder.userInfo

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.CreateContactRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateContactRequest(")
        append("attributes=$attributes,")
        append("channel=$channel,")
        append("clientToken=$clientToken,")
        append("description=*** Sensitive Data Redacted ***,")
        append("expiryDurationInMinutes=$expiryDurationInMinutes,")
        append("initiateAs=$initiateAs,")
        append("initiationMethod=$initiationMethod,")
        append("instanceId=$instanceId,")
        append("name=*** Sensitive Data Redacted ***,")
        append("references=$references,")
        append("relatedContactId=$relatedContactId,")
        append("segmentAttributes=$segmentAttributes,")
        append("userInfo=$userInfo")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributes?.hashCode() ?: 0
        result = 31 * result + (channel?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (expiryDurationInMinutes ?: 0)
        result = 31 * result + (initiateAs?.hashCode() ?: 0)
        result = 31 * result + (initiationMethod?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (references?.hashCode() ?: 0)
        result = 31 * result + (relatedContactId?.hashCode() ?: 0)
        result = 31 * result + (segmentAttributes?.hashCode() ?: 0)
        result = 31 * result + (userInfo?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateContactRequest

        if (attributes != other.attributes) return false
        if (channel != other.channel) return false
        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (expiryDurationInMinutes != other.expiryDurationInMinutes) return false
        if (initiateAs != other.initiateAs) return false
        if (initiationMethod != other.initiationMethod) return false
        if (instanceId != other.instanceId) return false
        if (name != other.name) return false
        if (references != other.references) return false
        if (relatedContactId != other.relatedContactId) return false
        if (segmentAttributes != other.segmentAttributes) return false
        if (userInfo != other.userInfo) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.CreateContactRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes, and can be accessed in flows just like any other contact attributes.
         *
         * There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only alphanumeric, dash, and underscore characters.
         */
        public var attributes: Map<String, String>? = null
        /**
         * The channel for the contact
         *
         * CreateContact only supports the EMAIL channel. The following information that states other channels are supported is incorrect. We are working to update this topic.
         */
        public var channel: aws.sdk.kotlin.services.connect.model.Channel? = null
        /**
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see [Making retries safe with idempotent APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
         */
        public var clientToken: kotlin.String? = null
        /**
         * A description of the contact.
         */
        public var description: kotlin.String? = null
        /**
         * Number of minutes the contact will be active for before expiring
         */
        public var expiryDurationInMinutes: kotlin.Int? = null
        /**
         * Initial state of the contact when it's created
         */
        public var initiateAs: aws.sdk.kotlin.services.connect.model.InitiateAs? = null
        /**
         * Indicates how the contact was initiated.
         *
         * CreateContact only supports the following initiation methods: OUTBOUND, AGENT_REPLY, and FLOW. The following information that states other initiation methods are supported is incorrect. We are working to update this topic.
         */
        public var initiationMethod: aws.sdk.kotlin.services.connect.model.ContactInitiationMethod? = null
        /**
         * The identifier of the Amazon Connect instance. You can [find the instance ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html) in the Amazon Resource Name (ARN) of the instance.
         */
        public var instanceId: kotlin.String? = null
        /**
         * The name of a the contact.
         */
        public var name: kotlin.String? = null
        /**
         * A formatted URL that is shown to an agent in the Contact Control Panel (CCP). Tasks can have the following reference types at the time of creation: URL | NUMBER | STRING | DATE | EMAIL | ATTACHMENT.
         */
        public var references: Map<String, Reference>? = null
        /**
         * The identifier of the contact in this instance of Amazon Connect.
         */
        public var relatedContactId: kotlin.String? = null
        /**
         * A set of system defined key-value pairs stored on individual contact segments (unique contact ID) using an attribute map. The attributes are standard Amazon Connect attributes. They can be accessed in flows.
         *
         * Attribute keys can include only alphanumeric, -, and _.
         *
         * This field can be used to set Segment Contact Expiry as a duration in minutes.
         *
         * To set contact expiry, a ValueMap must be specified containing the integer number of minutes the contact will be active for before expiring, with `SegmentAttributes` like { ` "connect:ContactExpiry": {"ValueMap" : { "ExpiryDuration": { "ValueInteger": 135}}}}`.
         */
        public var segmentAttributes: Map<String, SegmentAttributeValue>? = null
        /**
         * User details for the contact
         */
        public var userInfo: aws.sdk.kotlin.services.connect.model.UserInfo? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.CreateContactRequest) : this() {
            this.attributes = x.attributes
            this.channel = x.channel
            this.clientToken = x.clientToken
            this.description = x.description
            this.expiryDurationInMinutes = x.expiryDurationInMinutes
            this.initiateAs = x.initiateAs
            this.initiationMethod = x.initiationMethod
            this.instanceId = x.instanceId
            this.name = x.name
            this.references = x.references
            this.relatedContactId = x.relatedContactId
            this.segmentAttributes = x.segmentAttributes
            this.userInfo = x.userInfo
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.CreateContactRequest = CreateContactRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.UserInfo] inside the given [block]
         */
        public fun userInfo(block: aws.sdk.kotlin.services.connect.model.UserInfo.Builder.() -> kotlin.Unit) {
            this.userInfo = aws.sdk.kotlin.services.connect.model.UserInfo.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
