// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about a flow.
 */
public class ContactFlow private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the flow.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The JSON string that represents the content of the flow. For an example, see [Example flow in Amazon Connect Flow language](https://docs.aws.amazon.com/connect/latest/APIReference/flow-language-example.html).
     *
     * Length Constraints: Minimum length of 1. Maximum length of 256000.
     */
    public val content: kotlin.String? = builder.content
    /**
     * The description of the flow.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Indicates the checksum value of the flow content.
     */
    public val flowContentSha256: kotlin.String? = builder.flowContentSha256
    /**
     * The identifier of the flow.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The region in which the flow was last modified
     */
    public val lastModifiedRegion: kotlin.String? = builder.lastModifiedRegion
    /**
     * The time at which the flow was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The name of the flow.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The type of flow.
     */
    public val state: aws.sdk.kotlin.services.connect.model.ContactFlowState? = builder.state
    /**
     * The status of the flow.
     */
    public val status: aws.sdk.kotlin.services.connect.model.ContactFlowStatus? = builder.status
    /**
     * The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The type of the flow. For descriptions of the available types, see [Choose a flow type](https://docs.aws.amazon.com/connect/latest/adminguide/create-contact-flow.html#contact-flow-types) in the *Amazon Connect Administrator Guide*.
     */
    public val type: aws.sdk.kotlin.services.connect.model.ContactFlowType? = builder.type
    /**
     * The identifier of the flow version.
     */
    public val version: kotlin.Long? = builder.version
    /**
     * The description of the flow version.
     */
    public val versionDescription: kotlin.String? = builder.versionDescription

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.ContactFlow = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ContactFlow(")
        append("arn=$arn,")
        append("content=$content,")
        append("description=$description,")
        append("flowContentSha256=$flowContentSha256,")
        append("id=$id,")
        append("lastModifiedRegion=$lastModifiedRegion,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("name=$name,")
        append("state=$state,")
        append("status=$status,")
        append("tags=$tags,")
        append("type=$type,")
        append("version=$version,")
        append("versionDescription=$versionDescription")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (content?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (flowContentSha256?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedRegion?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        result = 31 * result + (versionDescription?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ContactFlow

        if (arn != other.arn) return false
        if (content != other.content) return false
        if (description != other.description) return false
        if (flowContentSha256 != other.flowContentSha256) return false
        if (id != other.id) return false
        if (lastModifiedRegion != other.lastModifiedRegion) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (name != other.name) return false
        if (state != other.state) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (type != other.type) return false
        if (version != other.version) return false
        if (versionDescription != other.versionDescription) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.ContactFlow = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the flow.
         */
        public var arn: kotlin.String? = null
        /**
         * The JSON string that represents the content of the flow. For an example, see [Example flow in Amazon Connect Flow language](https://docs.aws.amazon.com/connect/latest/APIReference/flow-language-example.html).
         *
         * Length Constraints: Minimum length of 1. Maximum length of 256000.
         */
        public var content: kotlin.String? = null
        /**
         * The description of the flow.
         */
        public var description: kotlin.String? = null
        /**
         * Indicates the checksum value of the flow content.
         */
        public var flowContentSha256: kotlin.String? = null
        /**
         * The identifier of the flow.
         */
        public var id: kotlin.String? = null
        /**
         * The region in which the flow was last modified
         */
        public var lastModifiedRegion: kotlin.String? = null
        /**
         * The time at which the flow was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the flow.
         */
        public var name: kotlin.String? = null
        /**
         * The type of flow.
         */
        public var state: aws.sdk.kotlin.services.connect.model.ContactFlowState? = null
        /**
         * The status of the flow.
         */
        public var status: aws.sdk.kotlin.services.connect.model.ContactFlowStatus? = null
        /**
         * The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.
         */
        public var tags: Map<String, String>? = null
        /**
         * The type of the flow. For descriptions of the available types, see [Choose a flow type](https://docs.aws.amazon.com/connect/latest/adminguide/create-contact-flow.html#contact-flow-types) in the *Amazon Connect Administrator Guide*.
         */
        public var type: aws.sdk.kotlin.services.connect.model.ContactFlowType? = null
        /**
         * The identifier of the flow version.
         */
        public var version: kotlin.Long? = null
        /**
         * The description of the flow version.
         */
        public var versionDescription: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.ContactFlow) : this() {
            this.arn = x.arn
            this.content = x.content
            this.description = x.description
            this.flowContentSha256 = x.flowContentSha256
            this.id = x.id
            this.lastModifiedRegion = x.lastModifiedRegion
            this.lastModifiedTime = x.lastModifiedTime
            this.name = x.name
            this.state = x.state
            this.status = x.status
            this.tags = x.tags
            this.type = x.type
            this.version = x.version
            this.versionDescription = x.versionDescription
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.ContactFlow = ContactFlow(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
