// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Request object with information to create a contact.
 */
public class ContactDataRequest private constructor(builder: Builder) {
    /**
     * List of attributes to be stored in a contact.
     */
    public val attributes: Map<String, String>? = builder.attributes
    /**
     * Structure to store information associated with a campaign.
     */
    public val campaign: aws.sdk.kotlin.services.connect.model.Campaign? = builder.campaign
    /**
     * Endpoint of the customer for which contact will be initiated.
     */
    public val customerEndpoint: aws.sdk.kotlin.services.connect.model.Endpoint? = builder.customerEndpoint
    /**
     * The identifier of the queue associated with the Amazon Connect instance in which contacts that are created will be queued.
     */
    public val queueId: kotlin.String? = builder.queueId
    /**
     * Identifier to uniquely identify individual requests in the batch.
     */
    public val requestIdentifier: kotlin.String? = builder.requestIdentifier
    /**
     * Endpoint associated with the Amazon Connect instance from which outbound contact will be initiated for the campaign.
     */
    public val systemEndpoint: aws.sdk.kotlin.services.connect.model.Endpoint? = builder.systemEndpoint

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.ContactDataRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ContactDataRequest(")
        append("attributes=$attributes,")
        append("campaign=$campaign,")
        append("customerEndpoint=$customerEndpoint,")
        append("queueId=$queueId,")
        append("requestIdentifier=$requestIdentifier,")
        append("systemEndpoint=$systemEndpoint")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributes?.hashCode() ?: 0
        result = 31 * result + (campaign?.hashCode() ?: 0)
        result = 31 * result + (customerEndpoint?.hashCode() ?: 0)
        result = 31 * result + (queueId?.hashCode() ?: 0)
        result = 31 * result + (requestIdentifier?.hashCode() ?: 0)
        result = 31 * result + (systemEndpoint?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ContactDataRequest

        if (attributes != other.attributes) return false
        if (campaign != other.campaign) return false
        if (customerEndpoint != other.customerEndpoint) return false
        if (queueId != other.queueId) return false
        if (requestIdentifier != other.requestIdentifier) return false
        if (systemEndpoint != other.systemEndpoint) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.ContactDataRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * List of attributes to be stored in a contact.
         */
        public var attributes: Map<String, String>? = null
        /**
         * Structure to store information associated with a campaign.
         */
        public var campaign: aws.sdk.kotlin.services.connect.model.Campaign? = null
        /**
         * Endpoint of the customer for which contact will be initiated.
         */
        public var customerEndpoint: aws.sdk.kotlin.services.connect.model.Endpoint? = null
        /**
         * The identifier of the queue associated with the Amazon Connect instance in which contacts that are created will be queued.
         */
        public var queueId: kotlin.String? = null
        /**
         * Identifier to uniquely identify individual requests in the batch.
         */
        public var requestIdentifier: kotlin.String? = null
        /**
         * Endpoint associated with the Amazon Connect instance from which outbound contact will be initiated for the campaign.
         */
        public var systemEndpoint: aws.sdk.kotlin.services.connect.model.Endpoint? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.ContactDataRequest) : this() {
            this.attributes = x.attributes
            this.campaign = x.campaign
            this.customerEndpoint = x.customerEndpoint
            this.queueId = x.queueId
            this.requestIdentifier = x.requestIdentifier
            this.systemEndpoint = x.systemEndpoint
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.ContactDataRequest = ContactDataRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.Campaign] inside the given [block]
         */
        public fun campaign(block: aws.sdk.kotlin.services.connect.model.Campaign.Builder.() -> kotlin.Unit) {
            this.campaign = aws.sdk.kotlin.services.connect.model.Campaign.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.Endpoint] inside the given [block]
         */
        public fun customerEndpoint(block: aws.sdk.kotlin.services.connect.model.Endpoint.Builder.() -> kotlin.Unit) {
            this.customerEndpoint = aws.sdk.kotlin.services.connect.model.Endpoint.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.Endpoint] inside the given [block]
         */
        public fun systemEndpoint(block: aws.sdk.kotlin.services.connect.model.Endpoint.Builder.() -> kotlin.Unit) {
            this.systemEndpoint = aws.sdk.kotlin.services.connect.model.Endpoint.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
