// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The contact configuration for push notification registration.
 */
public class ContactConfiguration private constructor(builder: Builder) {
    /**
     * The identifier of the contact within the Amazon Connect instance.
     */
    public val contactId: kotlin.String = requireNotNull(builder.contactId) { "A non-null value must be provided for contactId" }
    /**
     * Whether to include raw connect message in the push notification payload. Default is `False`.
     */
    public val includeRawMessage: kotlin.Boolean = builder.includeRawMessage
    /**
     * The role of the participant in the chat conversation.
     *
     * Only `CUSTOMER` is currently supported. Any other values other than `CUSTOMER` will result in an exception (4xx error).
     */
    public val participantRole: aws.sdk.kotlin.services.connect.model.ParticipantRole? = builder.participantRole

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.ContactConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ContactConfiguration(")
        append("contactId=$contactId,")
        append("includeRawMessage=$includeRawMessage,")
        append("participantRole=$participantRole")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = contactId.hashCode()
        result = 31 * result + (includeRawMessage.hashCode())
        result = 31 * result + (participantRole?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ContactConfiguration

        if (contactId != other.contactId) return false
        if (includeRawMessage != other.includeRawMessage) return false
        if (participantRole != other.participantRole) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.ContactConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier of the contact within the Amazon Connect instance.
         */
        public var contactId: kotlin.String? = null
        /**
         * Whether to include raw connect message in the push notification payload. Default is `False`.
         */
        public var includeRawMessage: kotlin.Boolean = false
        /**
         * The role of the participant in the chat conversation.
         *
         * Only `CUSTOMER` is currently supported. Any other values other than `CUSTOMER` will result in an exception (4xx error).
         */
        public var participantRole: aws.sdk.kotlin.services.connect.model.ParticipantRole? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.ContactConfiguration) : this() {
            this.contactId = x.contactId
            this.includeRawMessage = x.includeRawMessage
            this.participantRole = x.participantRole
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.ContactConfiguration = ContactConfiguration(this)

        internal fun correctErrors(): Builder {
            if (contactId == null) contactId = ""
            return this
        }
    }
}
