// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about a phone number that has been claimed to your Amazon Connect instance or traffic distribution group.
 */
public class ClaimedPhoneNumberSummary private constructor(builder: Builder) {
    /**
     * The identifier of the Amazon Connect instance that phone numbers are claimed to. You can [find the instance ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html) in the Amazon Resource Name (ARN) of the instance.
     */
    public val instanceId: kotlin.String? = builder.instanceId
    /**
     * The phone number. Phone numbers are formatted `[+] [country code] [subscriber number including area code]`.
     */
    public val phoneNumber: kotlin.String? = builder.phoneNumber
    /**
     * The Amazon Resource Name (ARN) of the phone number.
     */
    public val phoneNumberArn: kotlin.String? = builder.phoneNumberArn
    /**
     * The ISO country code.
     */
    public val phoneNumberCountryCode: aws.sdk.kotlin.services.connect.model.PhoneNumberCountryCode? = builder.phoneNumberCountryCode
    /**
     * The description of the phone number.
     */
    public val phoneNumberDescription: kotlin.String? = builder.phoneNumberDescription
    /**
     * A unique identifier for the phone number.
     */
    public val phoneNumberId: kotlin.String? = builder.phoneNumberId
    /**
     * The status of the phone number.
     * + `CLAIMED` means the previous [ClaimPhoneNumber](https://docs.aws.amazon.com/connect/latest/APIReference/API_ClaimPhoneNumber.html) or [UpdatePhoneNumber](https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdatePhoneNumber.html) operation succeeded.
     * + `IN_PROGRESS` means a [ClaimPhoneNumber](https://docs.aws.amazon.com/connect/latest/APIReference/API_ClaimPhoneNumber.html), [UpdatePhoneNumber](https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdatePhoneNumber.html), or [UpdatePhoneNumberMetadata](https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdatePhoneNumberMetadata.html) operation is still in progress and has not yet completed. You can call [DescribePhoneNumber](https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribePhoneNumber.html) at a later time to verify if the previous operation has completed.
     * + `FAILED` indicates that the previous [ClaimPhoneNumber](https://docs.aws.amazon.com/connect/latest/APIReference/API_ClaimPhoneNumber.html) or [UpdatePhoneNumber](https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdatePhoneNumber.html) operation has failed. It will include a message indicating the failure reason. A common reason for a failure may be that the `TargetArn` value you are claiming or updating a phone number to has reached its limit of total claimed numbers. If you received a `FAILED` status from a `ClaimPhoneNumber` API call, you have one day to retry claiming the phone number before the number is released back to the inventory for other customers to claim.
     *
     * You will not be billed for the phone number during the 1-day period if number claiming fails.
     */
    public val phoneNumberStatus: aws.sdk.kotlin.services.connect.model.PhoneNumberStatus? = builder.phoneNumberStatus
    /**
     * The type of phone number.
     */
    public val phoneNumberType: aws.sdk.kotlin.services.connect.model.PhoneNumberType? = builder.phoneNumberType
    /**
     * The claimed phone number ARN that was previously imported from the external service, such as Amazon Web Services End User Messaging. If it is from Amazon Web Services End User Messaging, it looks like the ARN of the phone number that was imported from Amazon Web Services End User Messaging.
     */
    public val sourcePhoneNumberArn: kotlin.String? = builder.sourcePhoneNumberArn
    /**
     * The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The Amazon Resource Name (ARN) for Amazon Connect instances or traffic distribution groups that phone number inbound traffic is routed through.
     */
    public val targetArn: kotlin.String? = builder.targetArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.ClaimedPhoneNumberSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ClaimedPhoneNumberSummary(")
        append("instanceId=$instanceId,")
        append("phoneNumber=$phoneNumber,")
        append("phoneNumberArn=$phoneNumberArn,")
        append("phoneNumberCountryCode=$phoneNumberCountryCode,")
        append("phoneNumberDescription=$phoneNumberDescription,")
        append("phoneNumberId=$phoneNumberId,")
        append("phoneNumberStatus=$phoneNumberStatus,")
        append("phoneNumberType=$phoneNumberType,")
        append("sourcePhoneNumberArn=$sourcePhoneNumberArn,")
        append("tags=$tags,")
        append("targetArn=$targetArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = instanceId?.hashCode() ?: 0
        result = 31 * result + (phoneNumber?.hashCode() ?: 0)
        result = 31 * result + (phoneNumberArn?.hashCode() ?: 0)
        result = 31 * result + (phoneNumberCountryCode?.hashCode() ?: 0)
        result = 31 * result + (phoneNumberDescription?.hashCode() ?: 0)
        result = 31 * result + (phoneNumberId?.hashCode() ?: 0)
        result = 31 * result + (phoneNumberStatus?.hashCode() ?: 0)
        result = 31 * result + (phoneNumberType?.hashCode() ?: 0)
        result = 31 * result + (sourcePhoneNumberArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ClaimedPhoneNumberSummary

        if (instanceId != other.instanceId) return false
        if (phoneNumber != other.phoneNumber) return false
        if (phoneNumberArn != other.phoneNumberArn) return false
        if (phoneNumberCountryCode != other.phoneNumberCountryCode) return false
        if (phoneNumberDescription != other.phoneNumberDescription) return false
        if (phoneNumberId != other.phoneNumberId) return false
        if (phoneNumberStatus != other.phoneNumberStatus) return false
        if (phoneNumberType != other.phoneNumberType) return false
        if (sourcePhoneNumberArn != other.sourcePhoneNumberArn) return false
        if (tags != other.tags) return false
        if (targetArn != other.targetArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.ClaimedPhoneNumberSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier of the Amazon Connect instance that phone numbers are claimed to. You can [find the instance ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html) in the Amazon Resource Name (ARN) of the instance.
         */
        public var instanceId: kotlin.String? = null
        /**
         * The phone number. Phone numbers are formatted `[+] [country code] [subscriber number including area code]`.
         */
        public var phoneNumber: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the phone number.
         */
        public var phoneNumberArn: kotlin.String? = null
        /**
         * The ISO country code.
         */
        public var phoneNumberCountryCode: aws.sdk.kotlin.services.connect.model.PhoneNumberCountryCode? = null
        /**
         * The description of the phone number.
         */
        public var phoneNumberDescription: kotlin.String? = null
        /**
         * A unique identifier for the phone number.
         */
        public var phoneNumberId: kotlin.String? = null
        /**
         * The status of the phone number.
         * + `CLAIMED` means the previous [ClaimPhoneNumber](https://docs.aws.amazon.com/connect/latest/APIReference/API_ClaimPhoneNumber.html) or [UpdatePhoneNumber](https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdatePhoneNumber.html) operation succeeded.
         * + `IN_PROGRESS` means a [ClaimPhoneNumber](https://docs.aws.amazon.com/connect/latest/APIReference/API_ClaimPhoneNumber.html), [UpdatePhoneNumber](https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdatePhoneNumber.html), or [UpdatePhoneNumberMetadata](https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdatePhoneNumberMetadata.html) operation is still in progress and has not yet completed. You can call [DescribePhoneNumber](https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribePhoneNumber.html) at a later time to verify if the previous operation has completed.
         * + `FAILED` indicates that the previous [ClaimPhoneNumber](https://docs.aws.amazon.com/connect/latest/APIReference/API_ClaimPhoneNumber.html) or [UpdatePhoneNumber](https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdatePhoneNumber.html) operation has failed. It will include a message indicating the failure reason. A common reason for a failure may be that the `TargetArn` value you are claiming or updating a phone number to has reached its limit of total claimed numbers. If you received a `FAILED` status from a `ClaimPhoneNumber` API call, you have one day to retry claiming the phone number before the number is released back to the inventory for other customers to claim.
         *
         * You will not be billed for the phone number during the 1-day period if number claiming fails.
         */
        public var phoneNumberStatus: aws.sdk.kotlin.services.connect.model.PhoneNumberStatus? = null
        /**
         * The type of phone number.
         */
        public var phoneNumberType: aws.sdk.kotlin.services.connect.model.PhoneNumberType? = null
        /**
         * The claimed phone number ARN that was previously imported from the external service, such as Amazon Web Services End User Messaging. If it is from Amazon Web Services End User Messaging, it looks like the ARN of the phone number that was imported from Amazon Web Services End User Messaging.
         */
        public var sourcePhoneNumberArn: kotlin.String? = null
        /**
         * The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.
         */
        public var tags: Map<String, String>? = null
        /**
         * The Amazon Resource Name (ARN) for Amazon Connect instances or traffic distribution groups that phone number inbound traffic is routed through.
         */
        public var targetArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.ClaimedPhoneNumberSummary) : this() {
            this.instanceId = x.instanceId
            this.phoneNumber = x.phoneNumber
            this.phoneNumberArn = x.phoneNumberArn
            this.phoneNumberCountryCode = x.phoneNumberCountryCode
            this.phoneNumberDescription = x.phoneNumberDescription
            this.phoneNumberId = x.phoneNumberId
            this.phoneNumberStatus = x.phoneNumberStatus
            this.phoneNumberType = x.phoneNumberType
            this.sourcePhoneNumberArn = x.sourcePhoneNumberArn
            this.tags = x.tags
            this.targetArn = x.targetArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.ClaimedPhoneNumberSummary = ClaimedPhoneNumberSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.PhoneNumberStatus] inside the given [block]
         */
        public fun phoneNumberStatus(block: aws.sdk.kotlin.services.connect.model.PhoneNumberStatus.Builder.() -> kotlin.Unit) {
            this.phoneNumberStatus = aws.sdk.kotlin.services.connect.model.PhoneNumberStatus.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
