// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * This API is in preview release for Amazon Connect and is subject to change. To request access to this API, contact Amazon Web ServicesSupport.
 *
 * A summary of a given authentication profile.
 */
public class AuthenticationProfileSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the authentication profile summary.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The unique identifier of the authentication profile.
     */
    public val id: kotlin.String? = builder.id
    /**
     * Shows whether the authentication profile is the default authentication profile for the Amazon Connect instance. The default authentication profile applies to all agents in an Amazon Connect instance, unless overridden by another authentication profile.
     */
    public val isDefault: kotlin.Boolean = builder.isDefault
    /**
     * The Amazon Web Services Region when the authentication profile summary was last modified.
     */
    public val lastModifiedRegion: kotlin.String? = builder.lastModifiedRegion
    /**
     * The timestamp when the authentication profile summary was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The name of the authentication profile summary.
     */
    public val name: kotlin.String? = builder.name

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.AuthenticationProfileSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AuthenticationProfileSummary(")
        append("arn=$arn,")
        append("id=$id,")
        append("isDefault=$isDefault,")
        append("lastModifiedRegion=$lastModifiedRegion,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("name=$name")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (isDefault.hashCode())
        result = 31 * result + (lastModifiedRegion?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AuthenticationProfileSummary

        if (arn != other.arn) return false
        if (id != other.id) return false
        if (isDefault != other.isDefault) return false
        if (lastModifiedRegion != other.lastModifiedRegion) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.AuthenticationProfileSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the authentication profile summary.
         */
        public var arn: kotlin.String? = null
        /**
         * The unique identifier of the authentication profile.
         */
        public var id: kotlin.String? = null
        /**
         * Shows whether the authentication profile is the default authentication profile for the Amazon Connect instance. The default authentication profile applies to all agents in an Amazon Connect instance, unless overridden by another authentication profile.
         */
        public var isDefault: kotlin.Boolean = false
        /**
         * The Amazon Web Services Region when the authentication profile summary was last modified.
         */
        public var lastModifiedRegion: kotlin.String? = null
        /**
         * The timestamp when the authentication profile summary was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the authentication profile summary.
         */
        public var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.AuthenticationProfileSummary) : this() {
            this.arn = x.arn
            this.id = x.id
            this.isDefault = x.isDefault
            this.lastModifiedRegion = x.lastModifiedRegion
            this.lastModifiedTime = x.lastModifiedTime
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.AuthenticationProfileSummary = AuthenticationProfileSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
