// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * This API is in preview release for Amazon Connect and is subject to change. To request access to this API, contact Amazon Web ServicesSupport.
 *
 * Information about an authentication profile. An authentication profile is a resource that stores the authentication settings for users in your contact center. You use authentication profiles to set up IP address range restrictions and session timeouts. For more information, see [Set IP address restrictions or session timeouts](https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html).
 */
public class AuthenticationProfile private constructor(builder: Builder) {
    /**
     * A list of IP address range strings that are allowed to access the Amazon Connect instance. For more information about how to configure IP addresses, see [Configure IP address based access control](https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html#configure-ip-based-ac) in the *Amazon Connect Administrator Guide*.
     */
    public val allowedIps: List<String>? = builder.allowedIps
    /**
     * The Amazon Resource Name (ARN) for the authentication profile.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * A list of IP address range strings that are blocked from accessing the Amazon Connect instance. For more information about how to configure IP addresses, see [Configure IP address based access control](https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html#configure-ip-based-ac) in the *Amazon Connect Administrator Guide*.
     */
    public val blockedIps: List<String>? = builder.blockedIps
    /**
     * The timestamp when the authentication profile was created.
     */
    public val createdTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTime
    /**
     * The description for the authentication profile.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A unique identifier for the authentication profile.
     */
    public val id: kotlin.String? = builder.id
    /**
     * Shows whether the authentication profile is the default authentication profile for the Amazon Connect instance. The default authentication profile applies to all agents in an Amazon Connect instance, unless overridden by another authentication profile.
     */
    public val isDefault: kotlin.Boolean = builder.isDefault
    /**
     * The Amazon Web Services Region where the authentication profile was last modified.
     */
    public val lastModifiedRegion: kotlin.String? = builder.lastModifiedRegion
    /**
     * The timestamp when the authentication profile was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The long lived session duration for users logged in to Amazon Connect, in minutes. After this time period, users must log in again. For more information, see [Configure the session duration](https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html#configure-session-timeouts) in the *Amazon Connect Administrator Guide*.
     */
    public val maxSessionDuration: kotlin.Int? = builder.maxSessionDuration
    /**
     * The name for the authentication profile.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The short lived session duration configuration for users logged in to Amazon Connect, in minutes. This value determines the maximum possible time before an agent is authenticated. For more information, see [Configure the session duration](https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html#configure-session-timeouts) in the *Amazon Connect Administrator Guide*.
     */
    public val periodicSessionDuration: kotlin.Int? = builder.periodicSessionDuration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.AuthenticationProfile = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AuthenticationProfile(")
        append("allowedIps=$allowedIps,")
        append("arn=$arn,")
        append("blockedIps=$blockedIps,")
        append("createdTime=$createdTime,")
        append("description=$description,")
        append("id=$id,")
        append("isDefault=$isDefault,")
        append("lastModifiedRegion=$lastModifiedRegion,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("maxSessionDuration=$maxSessionDuration,")
        append("name=$name,")
        append("periodicSessionDuration=$periodicSessionDuration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowedIps?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (blockedIps?.hashCode() ?: 0)
        result = 31 * result + (createdTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (isDefault.hashCode())
        result = 31 * result + (lastModifiedRegion?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (maxSessionDuration ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (periodicSessionDuration ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AuthenticationProfile

        if (allowedIps != other.allowedIps) return false
        if (arn != other.arn) return false
        if (blockedIps != other.blockedIps) return false
        if (createdTime != other.createdTime) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (isDefault != other.isDefault) return false
        if (lastModifiedRegion != other.lastModifiedRegion) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (maxSessionDuration != other.maxSessionDuration) return false
        if (name != other.name) return false
        if (periodicSessionDuration != other.periodicSessionDuration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.AuthenticationProfile = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list of IP address range strings that are allowed to access the Amazon Connect instance. For more information about how to configure IP addresses, see [Configure IP address based access control](https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html#configure-ip-based-ac) in the *Amazon Connect Administrator Guide*.
         */
        public var allowedIps: List<String>? = null
        /**
         * The Amazon Resource Name (ARN) for the authentication profile.
         */
        public var arn: kotlin.String? = null
        /**
         * A list of IP address range strings that are blocked from accessing the Amazon Connect instance. For more information about how to configure IP addresses, see [Configure IP address based access control](https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html#configure-ip-based-ac) in the *Amazon Connect Administrator Guide*.
         */
        public var blockedIps: List<String>? = null
        /**
         * The timestamp when the authentication profile was created.
         */
        public var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description for the authentication profile.
         */
        public var description: kotlin.String? = null
        /**
         * A unique identifier for the authentication profile.
         */
        public var id: kotlin.String? = null
        /**
         * Shows whether the authentication profile is the default authentication profile for the Amazon Connect instance. The default authentication profile applies to all agents in an Amazon Connect instance, unless overridden by another authentication profile.
         */
        public var isDefault: kotlin.Boolean = false
        /**
         * The Amazon Web Services Region where the authentication profile was last modified.
         */
        public var lastModifiedRegion: kotlin.String? = null
        /**
         * The timestamp when the authentication profile was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The long lived session duration for users logged in to Amazon Connect, in minutes. After this time period, users must log in again. For more information, see [Configure the session duration](https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html#configure-session-timeouts) in the *Amazon Connect Administrator Guide*.
         */
        public var maxSessionDuration: kotlin.Int? = null
        /**
         * The name for the authentication profile.
         */
        public var name: kotlin.String? = null
        /**
         * The short lived session duration configuration for users logged in to Amazon Connect, in minutes. This value determines the maximum possible time before an agent is authenticated. For more information, see [Configure the session duration](https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html#configure-session-timeouts) in the *Amazon Connect Administrator Guide*.
         */
        public var periodicSessionDuration: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.AuthenticationProfile) : this() {
            this.allowedIps = x.allowedIps
            this.arn = x.arn
            this.blockedIps = x.blockedIps
            this.createdTime = x.createdTime
            this.description = x.description
            this.id = x.id
            this.isDefault = x.isDefault
            this.lastModifiedRegion = x.lastModifiedRegion
            this.lastModifiedTime = x.lastModifiedTime
            this.maxSessionDuration = x.maxSessionDuration
            this.name = x.name
            this.periodicSessionDuration = x.periodicSessionDuration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.AuthenticationProfile = AuthenticationProfile(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
