// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains information for score and potential quality issues for Audio
 */
public class AudioQualityMetricsInfo private constructor(builder: Builder) {
    /**
     * List of potential issues causing degradation of quality on a media connection. If the service did not detect any potential quality issues the list is empty.
     *
     * Valid values: `HighPacketLoss` | `HighRoundTripTime` | `HighJitterBuffer`
     */
    public val potentialQualityIssues: List<String>? = builder.potentialQualityIssues
    /**
     * Number measuring the estimated quality of the media connection.
     */
    public val qualityScore: kotlin.Float = builder.qualityScore

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.AudioQualityMetricsInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AudioQualityMetricsInfo(")
        append("potentialQualityIssues=$potentialQualityIssues,")
        append("qualityScore=$qualityScore")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = potentialQualityIssues?.hashCode() ?: 0
        result = 31 * result + (qualityScore.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AudioQualityMetricsInfo

        if (potentialQualityIssues != other.potentialQualityIssues) return false
        if (!(qualityScore?.equals(other.qualityScore) ?: (other.qualityScore == null))) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.AudioQualityMetricsInfo = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * List of potential issues causing degradation of quality on a media connection. If the service did not detect any potential quality issues the list is empty.
         *
         * Valid values: `HighPacketLoss` | `HighRoundTripTime` | `HighJitterBuffer`
         */
        public var potentialQualityIssues: List<String>? = null
        /**
         * Number measuring the estimated quality of the media connection.
         */
        public var qualityScore: kotlin.Float = 0f

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.AudioQualityMetricsInfo) : this() {
            this.potentialQualityIssues = x.potentialQualityIssues
            this.qualityScore = x.qualityScore
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.AudioQualityMetricsInfo = AudioQualityMetricsInfo(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
