// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.SdkDsl

public class AssociateInstanceStorageConfigRequest private constructor(builder: Builder) {
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see [Making retries safe with idempotent APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The identifier of the Amazon Connect instance. You can [find the instance ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html) in the Amazon Resource Name (ARN) of the instance.
     */
    public val instanceId: kotlin.String? = builder.instanceId
    /**
     * A valid resource type. To [enable streaming for real-time analysis of contacts](https://docs.aws.amazon.com/connect/latest/adminguide/enable-contact-analysis-segment-streams.html), use the following types:
     * + For chat contacts, use `REAL_TIME_CONTACT_ANALYSIS_CHAT_SEGMENTS`.
     * + For voice contacts, use `REAL_TIME_CONTACT_ANALYSIS_VOICE_SEGMENTS`.
     *
     * `REAL_TIME_CONTACT_ANALYSIS_SEGMENTS` is deprecated, but it is still supported and will apply only to VOICE channel contacts. Use `REAL_TIME_CONTACT_ANALYSIS_VOICE_SEGMENTS` for voice contacts moving forward.
     *
     * If you have previously associated a stream with `REAL_TIME_CONTACT_ANALYSIS_SEGMENTS`, no action is needed to update the stream to `REAL_TIME_CONTACT_ANALYSIS_VOICE_SEGMENTS`.
     */
    public val resourceType: aws.sdk.kotlin.services.connect.model.InstanceStorageResourceType? = builder.resourceType
    /**
     * A valid storage type.
     */
    public val storageConfig: aws.sdk.kotlin.services.connect.model.InstanceStorageConfig? = builder.storageConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.AssociateInstanceStorageConfigRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssociateInstanceStorageConfigRequest(")
        append("clientToken=$clientToken,")
        append("instanceId=$instanceId,")
        append("resourceType=$resourceType,")
        append("storageConfig=$storageConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (storageConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssociateInstanceStorageConfigRequest

        if (clientToken != other.clientToken) return false
        if (instanceId != other.instanceId) return false
        if (resourceType != other.resourceType) return false
        if (storageConfig != other.storageConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.AssociateInstanceStorageConfigRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see [Making retries safe with idempotent APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
         */
        public var clientToken: kotlin.String? = null
        /**
         * The identifier of the Amazon Connect instance. You can [find the instance ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html) in the Amazon Resource Name (ARN) of the instance.
         */
        public var instanceId: kotlin.String? = null
        /**
         * A valid resource type. To [enable streaming for real-time analysis of contacts](https://docs.aws.amazon.com/connect/latest/adminguide/enable-contact-analysis-segment-streams.html), use the following types:
         * + For chat contacts, use `REAL_TIME_CONTACT_ANALYSIS_CHAT_SEGMENTS`.
         * + For voice contacts, use `REAL_TIME_CONTACT_ANALYSIS_VOICE_SEGMENTS`.
         *
         * `REAL_TIME_CONTACT_ANALYSIS_SEGMENTS` is deprecated, but it is still supported and will apply only to VOICE channel contacts. Use `REAL_TIME_CONTACT_ANALYSIS_VOICE_SEGMENTS` for voice contacts moving forward.
         *
         * If you have previously associated a stream with `REAL_TIME_CONTACT_ANALYSIS_SEGMENTS`, no action is needed to update the stream to `REAL_TIME_CONTACT_ANALYSIS_VOICE_SEGMENTS`.
         */
        public var resourceType: aws.sdk.kotlin.services.connect.model.InstanceStorageResourceType? = null
        /**
         * A valid storage type.
         */
        public var storageConfig: aws.sdk.kotlin.services.connect.model.InstanceStorageConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.AssociateInstanceStorageConfigRequest) : this() {
            this.clientToken = x.clientToken
            this.instanceId = x.instanceId
            this.resourceType = x.resourceType
            this.storageConfig = x.storageConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.AssociateInstanceStorageConfigRequest = AssociateInstanceStorageConfigRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.InstanceStorageConfig] inside the given [block]
         */
        public fun storageConfig(block: aws.sdk.kotlin.services.connect.model.InstanceStorageConfig.Builder.() -> kotlin.Unit) {
            this.storageConfig = aws.sdk.kotlin.services.connect.model.InstanceStorageConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
