// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.serde

import aws.sdk.kotlin.services.connect.model.AgentConfig
import aws.sdk.kotlin.services.connect.model.SignInConfig
import aws.sdk.kotlin.services.connect.model.TelephonyConfig
import aws.sdk.kotlin.services.connect.model.UpdateTrafficDistributionRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateTrafficDistributionOperationSerializer: HttpSerializer.NonStreaming<UpdateTrafficDistributionRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateTrafficDistributionRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.id) { "id is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("traffic-distribution"))
                add(PercentEncoding.SmithyLabel.encode(input.id))
            }
        }

        val payload = serializeUpdateTrafficDistributionOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateTrafficDistributionOperationBody(context: ExecutionContext, input: UpdateTrafficDistributionRequest): ByteArray {
    val serializer = JsonSerializer()
    val AGENTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AgentConfig"))
    val SIGNINCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SignInConfig"))
    val TELEPHONYCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("TelephonyConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AGENTCONFIG_DESCRIPTOR)
        field(SIGNINCONFIG_DESCRIPTOR)
        field(TELEPHONYCONFIG_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.agentConfig?.let { field(AGENTCONFIG_DESCRIPTOR, it, ::serializeAgentConfigDocument) }
        input.signInConfig?.let { field(SIGNINCONFIG_DESCRIPTOR, it, ::serializeSignInConfigDocument) }
        input.telephonyConfig?.let { field(TELEPHONYCONFIG_DESCRIPTOR, it, ::serializeTelephonyConfigDocument) }
    }
    return serializer.toByteArray()
}
