// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.serde

import aws.sdk.kotlin.services.connect.model.TaskTemplateConstraints
import aws.sdk.kotlin.services.connect.model.TaskTemplateDefaults
import aws.sdk.kotlin.services.connect.model.TaskTemplateField
import aws.sdk.kotlin.services.connect.model.TaskTemplateStatus
import aws.sdk.kotlin.services.connect.model.UpdateTaskTemplateRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateTaskTemplateOperationSerializer: HttpSerializer.NonStreaming<UpdateTaskTemplateRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateTaskTemplateRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.instanceId) { "instanceId is bound to the URI and must not be null" }
            requireNotNull(input.taskTemplateId) { "taskTemplateId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("instance"))
                add(PercentEncoding.SmithyLabel.encode(input.instanceId))
                add(PercentEncoding.Path.encode("task"))
                add(PercentEncoding.Path.encode("template"))
                add(PercentEncoding.SmithyLabel.encode(input.taskTemplateId))
            }
        }

        val payload = serializeUpdateTaskTemplateOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateTaskTemplateOperationBody(context: ExecutionContext, input: UpdateTaskTemplateRequest): ByteArray {
    val serializer = JsonSerializer()
    val CONSTRAINTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Constraints"))
    val CONTACTFLOWID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ContactFlowId"))
    val DEFAULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Defaults"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val FIELDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Fields"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONSTRAINTS_DESCRIPTOR)
        field(CONTACTFLOWID_DESCRIPTOR)
        field(DEFAULTS_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(FIELDS_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.constraints?.let { field(CONSTRAINTS_DESCRIPTOR, it, ::serializeTaskTemplateConstraintsDocument) }
        input.contactFlowId?.let { field(CONTACTFLOWID_DESCRIPTOR, it) }
        input.defaults?.let { field(DEFAULTS_DESCRIPTOR, it, ::serializeTaskTemplateDefaultsDocument) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        if (input.fields != null) {
            listField(FIELDS_DESCRIPTOR) {
                for (el0 in input.fields) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTaskTemplateFieldDocument))
                }
            }
        }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        input.status?.let { field(STATUS_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
