// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.serde

import aws.sdk.kotlin.services.connect.model.ConnectException
import aws.sdk.kotlin.services.connect.model.ListRealtimeContactAnalysisSegmentsV2Response
import aws.sdk.kotlin.services.connect.model.RealTimeContactAnalysisStatus
import aws.sdk.kotlin.services.connect.model.RealTimeContactAnalysisSupportedChannel
import aws.sdk.kotlin.services.connect.model.RealtimeContactAnalysisSegment
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListRealtimeContactAnalysisSegmentsV2OperationDeserializer: HttpDeserializer.NonStreaming<ListRealtimeContactAnalysisSegmentsV2Response> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ListRealtimeContactAnalysisSegmentsV2Response {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwListRealtimeContactAnalysisSegmentsV2Error(context, call, payload)
        }
        val builder = ListRealtimeContactAnalysisSegmentsV2Response.Builder()

        if (payload != null) {
            deserializeListRealtimeContactAnalysisSegmentsV2OperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwListRealtimeContactAnalysisSegmentsV2Error(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ConnectException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServiceException" -> InternalServiceExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "OutputTypeNotFoundException" -> OutputTypeNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ConnectException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListRealtimeContactAnalysisSegmentsV2OperationBody(builder: ListRealtimeContactAnalysisSegmentsV2Response.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CHANNEL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Channel"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val SEGMENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Segments"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CHANNEL_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(SEGMENTS_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CHANNEL_DESCRIPTOR.index -> builder.channel = deserializeString().let { RealTimeContactAnalysisSupportedChannel.fromValue(it) }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                SEGMENTS_DESCRIPTOR.index -> builder.segments =
                    deserializer.deserializeList(SEGMENTS_DESCRIPTOR) {
                        val col0 = mutableListOf<RealtimeContactAnalysisSegment>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeRealtimeContactAnalysisSegmentDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { RealTimeContactAnalysisStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
