// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.serde

import aws.sdk.kotlin.services.connect.model.ConnectException
import aws.sdk.kotlin.services.connect.model.Credentials
import aws.sdk.kotlin.services.connect.model.GetFederationTokenResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetFederationTokenOperationDeserializer: HttpDeserializer.NonStreaming<GetFederationTokenResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetFederationTokenResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetFederationTokenError(context, call, payload)
        }
        val builder = GetFederationTokenResponse.Builder()

        if (payload != null) {
            deserializeGetFederationTokenOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetFederationTokenError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ConnectException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DuplicateResourceException" -> DuplicateResourceExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServiceException" -> InternalServiceExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UserNotFoundException" -> UserNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ConnectException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetFederationTokenOperationBody(builder: GetFederationTokenResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREDENTIALS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Credentials"))
    val SIGNINURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SignInUrl"))
    val USERARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("UserArn"))
    val USERID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("UserId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREDENTIALS_DESCRIPTOR)
        field(SIGNINURL_DESCRIPTOR)
        field(USERARN_DESCRIPTOR)
        field(USERID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREDENTIALS_DESCRIPTOR.index -> builder.credentials = deserializeCredentialsDocument(deserializer)
                SIGNINURL_DESCRIPTOR.index -> builder.signInUrl = deserializeString()
                USERARN_DESCRIPTOR.index -> builder.userArn = deserializeString()
                USERID_DESCRIPTOR.index -> builder.userId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
