// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.serde

import aws.sdk.kotlin.services.connect.model.AssociateInstanceStorageConfigRequest
import aws.sdk.kotlin.services.connect.model.InstanceStorageConfig
import aws.sdk.kotlin.services.connect.model.InstanceStorageResourceType
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class AssociateInstanceStorageConfigOperationSerializer: HttpSerializer.NonStreaming<AssociateInstanceStorageConfigRequest> {
    override fun serialize(context: ExecutionContext, input: AssociateInstanceStorageConfigRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.instanceId) { "instanceId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("instance"))
                add(PercentEncoding.SmithyLabel.encode(input.instanceId))
                add(PercentEncoding.Path.encode("storage-config"))
            }
        }

        val payload = serializeAssociateInstanceStorageConfigOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeAssociateInstanceStorageConfigOperationBody(context: ExecutionContext, input: AssociateInstanceStorageConfigRequest): ByteArray {
    val serializer = JsonSerializer()
    val RESOURCETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ResourceType"))
    val STORAGECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("StorageConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(RESOURCETYPE_DESCRIPTOR)
        field(STORAGECONFIG_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.resourceType?.let { field(RESOURCETYPE_DESCRIPTOR, it.value) }
        input.storageConfig?.let { field(STORAGECONFIG_DESCRIPTOR, it, ::serializeInstanceStorageConfigDocument) }
    }
    return serializer.toByteArray()
}
