// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.SdkDsl

public class StartWebRtcContactRequest private constructor(builder: Builder) {
    /**
     * Information about the video sharing capabilities of the participants (customer, agent).
     */
    public val allowedCapabilities: aws.sdk.kotlin.services.connect.model.AllowedCapabilities? = builder.allowedCapabilities
    /**
     * A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes, and can be accessed in flows just like any other contact attributes.
     *
     * There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only alphanumeric, -, and _ characters.
     */
    public val attributes: Map<String, String>? = builder.attributes
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see [Making retries safe with idempotent APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
     *
     * The token is valid for 7 days after creation. If a contact is already started, the contact ID is returned.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The identifier of the flow for the call. To see the ContactFlowId in the Amazon Connect admin website, on the navigation menu go to **Routing**, **Contact Flows**. Choose the flow. On the flow page, under the name of the flow, choose **Show additional flow information**. The ContactFlowId is the last part of the ARN, shown here in bold:
     *
     * arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow&#47;**846ec553-a005-41c0-8341-xxxxxxxxxxxx**
     */
    public val contactFlowId: kotlin.String? = builder.contactFlowId
    /**
     * A description of the task that is shown to an agent in the Contact Control Panel (CCP).
     */
    public val description: kotlin.String? = builder.description
    /**
     * The identifier of the Amazon Connect instance. You can [find the instance ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html) in the Amazon Resource Name (ARN) of the instance.
     */
    public val instanceId: kotlin.String? = builder.instanceId
    /**
     * The customer's details.
     */
    public val participantDetails: aws.sdk.kotlin.services.connect.model.ParticipantDetails? = builder.participantDetails
    /**
     * A formatted URL that is shown to an agent in the Contact Control Panel (CCP). Tasks can have the following reference types at the time of creation: `URL` | `NUMBER` | `STRING` | `DATE` | `EMAIL`. `ATTACHMENT` is not a supported reference type during task creation.
     */
    public val references: Map<String, Reference>? = builder.references
    /**
     * The unique identifier for an Amazon Connect contact. This identifier is related to the contact starting.
     */
    public val relatedContactId: kotlin.String? = builder.relatedContactId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.StartWebRtcContactRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartWebRtcContactRequest(")
        append("allowedCapabilities=$allowedCapabilities,")
        append("attributes=$attributes,")
        append("clientToken=$clientToken,")
        append("contactFlowId=$contactFlowId,")
        append("description=*** Sensitive Data Redacted ***,")
        append("instanceId=$instanceId,")
        append("participantDetails=$participantDetails,")
        append("references=$references,")
        append("relatedContactId=$relatedContactId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowedCapabilities?.hashCode() ?: 0
        result = 31 * result + (attributes?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (contactFlowId?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (participantDetails?.hashCode() ?: 0)
        result = 31 * result + (references?.hashCode() ?: 0)
        result = 31 * result + (relatedContactId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartWebRtcContactRequest

        if (allowedCapabilities != other.allowedCapabilities) return false
        if (attributes != other.attributes) return false
        if (clientToken != other.clientToken) return false
        if (contactFlowId != other.contactFlowId) return false
        if (description != other.description) return false
        if (instanceId != other.instanceId) return false
        if (participantDetails != other.participantDetails) return false
        if (references != other.references) return false
        if (relatedContactId != other.relatedContactId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.StartWebRtcContactRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Information about the video sharing capabilities of the participants (customer, agent).
         */
        public var allowedCapabilities: aws.sdk.kotlin.services.connect.model.AllowedCapabilities? = null
        /**
         * A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes, and can be accessed in flows just like any other contact attributes.
         *
         * There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only alphanumeric, -, and _ characters.
         */
        public var attributes: Map<String, String>? = null
        /**
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see [Making retries safe with idempotent APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
         *
         * The token is valid for 7 days after creation. If a contact is already started, the contact ID is returned.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The identifier of the flow for the call. To see the ContactFlowId in the Amazon Connect admin website, on the navigation menu go to **Routing**, **Contact Flows**. Choose the flow. On the flow page, under the name of the flow, choose **Show additional flow information**. The ContactFlowId is the last part of the ARN, shown here in bold:
         *
         * arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow&#47;**846ec553-a005-41c0-8341-xxxxxxxxxxxx**
         */
        public var contactFlowId: kotlin.String? = null
        /**
         * A description of the task that is shown to an agent in the Contact Control Panel (CCP).
         */
        public var description: kotlin.String? = null
        /**
         * The identifier of the Amazon Connect instance. You can [find the instance ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html) in the Amazon Resource Name (ARN) of the instance.
         */
        public var instanceId: kotlin.String? = null
        /**
         * The customer's details.
         */
        public var participantDetails: aws.sdk.kotlin.services.connect.model.ParticipantDetails? = null
        /**
         * A formatted URL that is shown to an agent in the Contact Control Panel (CCP). Tasks can have the following reference types at the time of creation: `URL` | `NUMBER` | `STRING` | `DATE` | `EMAIL`. `ATTACHMENT` is not a supported reference type during task creation.
         */
        public var references: Map<String, Reference>? = null
        /**
         * The unique identifier for an Amazon Connect contact. This identifier is related to the contact starting.
         */
        public var relatedContactId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.StartWebRtcContactRequest) : this() {
            this.allowedCapabilities = x.allowedCapabilities
            this.attributes = x.attributes
            this.clientToken = x.clientToken
            this.contactFlowId = x.contactFlowId
            this.description = x.description
            this.instanceId = x.instanceId
            this.participantDetails = x.participantDetails
            this.references = x.references
            this.relatedContactId = x.relatedContactId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.StartWebRtcContactRequest = StartWebRtcContactRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.AllowedCapabilities] inside the given [block]
         */
        public fun allowedCapabilities(block: aws.sdk.kotlin.services.connect.model.AllowedCapabilities.Builder.() -> kotlin.Unit) {
            this.allowedCapabilities = aws.sdk.kotlin.services.connect.model.AllowedCapabilities.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.ParticipantDetails] inside the given [block]
         */
        public fun participantDetails(block: aws.sdk.kotlin.services.connect.model.ParticipantDetails.Builder.() -> kotlin.Unit) {
            this.participantDetails = aws.sdk.kotlin.services.connect.model.ParticipantDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
