// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.SdkDsl

public class StartOutboundVoiceContactRequest private constructor(builder: Builder) {
    /**
     * Configuration of the answering machine detection for this outbound call.
     */
    public val answerMachineDetectionConfig: aws.sdk.kotlin.services.connect.model.AnswerMachineDetectionConfig? = builder.answerMachineDetectionConfig
    /**
     * A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes, and can be accessed in flows just like any other contact attributes.
     *
     * There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only alphanumeric, dash, and underscore characters.
     */
    public val attributes: Map<String, String>? = builder.attributes
    /**
     * The campaign identifier of the outbound communication.
     */
    public val campaignId: kotlin.String? = builder.campaignId
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see [Making retries safe with idempotent APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/). The token is valid for 7 days after creation. If a contact is already started, the contact ID is returned.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The identifier of the flow for the outbound call. To see the ContactFlowId in the Amazon Connect admin website, on the navigation menu go to **Routing**, **Contact Flows**. Choose the flow. On the flow page, under the name of the flow, choose **Show additional flow information**. The ContactFlowId is the last part of the ARN, shown here in bold:
     *
     * arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow&#47;**846ec553-a005-41c0-8341-xxxxxxxxxxxx**
     */
    public val contactFlowId: kotlin.String? = builder.contactFlowId
    /**
     * A description of the voice contact that is shown to an agent in the Contact Control Panel (CCP).
     */
    public val description: kotlin.String? = builder.description
    /**
     * The phone number of the customer, in E.164 format.
     */
    public val destinationPhoneNumber: kotlin.String? = builder.destinationPhoneNumber
    /**
     * The identifier of the Amazon Connect instance. You can [find the instance ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html) in the Amazon Resource Name (ARN) of the instance.
     */
    public val instanceId: kotlin.String? = builder.instanceId
    /**
     * The name of a voice contact that is shown to an agent in the Contact Control Panel (CCP).
     */
    public val name: kotlin.String? = builder.name
    /**
     * The queue for the call. If you specify a queue, the phone displayed for caller ID is the phone number specified in the queue. If you do not specify a queue, the queue defined in the flow is used. If you do not specify a queue, you must specify a source phone number.
     */
    public val queueId: kotlin.String? = builder.queueId
    /**
     * A formatted URL that is shown to an agent in the Contact Control Panel (CCP). Contacts can have the following reference types at the time of creation: `URL` | `NUMBER` | `STRING` | `DATE` | `EMAIL`. `ATTACHMENT` is not a supported reference type during voice contact creation.
     */
    public val references: Map<String, Reference>? = builder.references
    /**
     * The `contactId` that is related to this contact. Linking voice, task, or chat by using `RelatedContactID` copies over contact attributes from the related contact to the new contact. All updates to user-defined attributes in the new contact are limited to the individual contact ID. There are no limits to the number of contacts that can be linked by using `RelatedContactId`.
     */
    public val relatedContactId: kotlin.String? = builder.relatedContactId
    /**
     * The phone number associated with the Amazon Connect instance, in E.164 format. If you do not specify a source phone number, you must specify a queue.
     */
    public val sourcePhoneNumber: kotlin.String? = builder.sourcePhoneNumber
    /**
     * Denotes the class of traffic. Calls with different traffic types are handled differently by Amazon Connect. The default value is `GENERAL`. Use `CAMPAIGN` if `EnableAnswerMachineDetection` is set to `true`. For all other cases, use `GENERAL`.
     */
    public val trafficType: aws.sdk.kotlin.services.connect.model.TrafficType? = builder.trafficType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.StartOutboundVoiceContactRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartOutboundVoiceContactRequest(")
        append("answerMachineDetectionConfig=$answerMachineDetectionConfig,")
        append("attributes=$attributes,")
        append("campaignId=$campaignId,")
        append("clientToken=$clientToken,")
        append("contactFlowId=$contactFlowId,")
        append("description=*** Sensitive Data Redacted ***,")
        append("destinationPhoneNumber=$destinationPhoneNumber,")
        append("instanceId=$instanceId,")
        append("name=*** Sensitive Data Redacted ***,")
        append("queueId=$queueId,")
        append("references=$references,")
        append("relatedContactId=$relatedContactId,")
        append("sourcePhoneNumber=$sourcePhoneNumber,")
        append("trafficType=$trafficType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = answerMachineDetectionConfig?.hashCode() ?: 0
        result = 31 * result + (attributes?.hashCode() ?: 0)
        result = 31 * result + (campaignId?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (contactFlowId?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (destinationPhoneNumber?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (queueId?.hashCode() ?: 0)
        result = 31 * result + (references?.hashCode() ?: 0)
        result = 31 * result + (relatedContactId?.hashCode() ?: 0)
        result = 31 * result + (sourcePhoneNumber?.hashCode() ?: 0)
        result = 31 * result + (trafficType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartOutboundVoiceContactRequest

        if (answerMachineDetectionConfig != other.answerMachineDetectionConfig) return false
        if (attributes != other.attributes) return false
        if (campaignId != other.campaignId) return false
        if (clientToken != other.clientToken) return false
        if (contactFlowId != other.contactFlowId) return false
        if (description != other.description) return false
        if (destinationPhoneNumber != other.destinationPhoneNumber) return false
        if (instanceId != other.instanceId) return false
        if (name != other.name) return false
        if (queueId != other.queueId) return false
        if (references != other.references) return false
        if (relatedContactId != other.relatedContactId) return false
        if (sourcePhoneNumber != other.sourcePhoneNumber) return false
        if (trafficType != other.trafficType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.StartOutboundVoiceContactRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Configuration of the answering machine detection for this outbound call.
         */
        public var answerMachineDetectionConfig: aws.sdk.kotlin.services.connect.model.AnswerMachineDetectionConfig? = null
        /**
         * A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes, and can be accessed in flows just like any other contact attributes.
         *
         * There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only alphanumeric, dash, and underscore characters.
         */
        public var attributes: Map<String, String>? = null
        /**
         * The campaign identifier of the outbound communication.
         */
        public var campaignId: kotlin.String? = null
        /**
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see [Making retries safe with idempotent APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/). The token is valid for 7 days after creation. If a contact is already started, the contact ID is returned.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The identifier of the flow for the outbound call. To see the ContactFlowId in the Amazon Connect admin website, on the navigation menu go to **Routing**, **Contact Flows**. Choose the flow. On the flow page, under the name of the flow, choose **Show additional flow information**. The ContactFlowId is the last part of the ARN, shown here in bold:
         *
         * arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow&#47;**846ec553-a005-41c0-8341-xxxxxxxxxxxx**
         */
        public var contactFlowId: kotlin.String? = null
        /**
         * A description of the voice contact that is shown to an agent in the Contact Control Panel (CCP).
         */
        public var description: kotlin.String? = null
        /**
         * The phone number of the customer, in E.164 format.
         */
        public var destinationPhoneNumber: kotlin.String? = null
        /**
         * The identifier of the Amazon Connect instance. You can [find the instance ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html) in the Amazon Resource Name (ARN) of the instance.
         */
        public var instanceId: kotlin.String? = null
        /**
         * The name of a voice contact that is shown to an agent in the Contact Control Panel (CCP).
         */
        public var name: kotlin.String? = null
        /**
         * The queue for the call. If you specify a queue, the phone displayed for caller ID is the phone number specified in the queue. If you do not specify a queue, the queue defined in the flow is used. If you do not specify a queue, you must specify a source phone number.
         */
        public var queueId: kotlin.String? = null
        /**
         * A formatted URL that is shown to an agent in the Contact Control Panel (CCP). Contacts can have the following reference types at the time of creation: `URL` | `NUMBER` | `STRING` | `DATE` | `EMAIL`. `ATTACHMENT` is not a supported reference type during voice contact creation.
         */
        public var references: Map<String, Reference>? = null
        /**
         * The `contactId` that is related to this contact. Linking voice, task, or chat by using `RelatedContactID` copies over contact attributes from the related contact to the new contact. All updates to user-defined attributes in the new contact are limited to the individual contact ID. There are no limits to the number of contacts that can be linked by using `RelatedContactId`.
         */
        public var relatedContactId: kotlin.String? = null
        /**
         * The phone number associated with the Amazon Connect instance, in E.164 format. If you do not specify a source phone number, you must specify a queue.
         */
        public var sourcePhoneNumber: kotlin.String? = null
        /**
         * Denotes the class of traffic. Calls with different traffic types are handled differently by Amazon Connect. The default value is `GENERAL`. Use `CAMPAIGN` if `EnableAnswerMachineDetection` is set to `true`. For all other cases, use `GENERAL`.
         */
        public var trafficType: aws.sdk.kotlin.services.connect.model.TrafficType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.StartOutboundVoiceContactRequest) : this() {
            this.answerMachineDetectionConfig = x.answerMachineDetectionConfig
            this.attributes = x.attributes
            this.campaignId = x.campaignId
            this.clientToken = x.clientToken
            this.contactFlowId = x.contactFlowId
            this.description = x.description
            this.destinationPhoneNumber = x.destinationPhoneNumber
            this.instanceId = x.instanceId
            this.name = x.name
            this.queueId = x.queueId
            this.references = x.references
            this.relatedContactId = x.relatedContactId
            this.sourcePhoneNumber = x.sourcePhoneNumber
            this.trafficType = x.trafficType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.StartOutboundVoiceContactRequest = StartOutboundVoiceContactRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.AnswerMachineDetectionConfig] inside the given [block]
         */
        public fun answerMachineDetectionConfig(block: aws.sdk.kotlin.services.connect.model.AnswerMachineDetectionConfig.Builder.() -> kotlin.Unit) {
            this.answerMachineDetectionConfig = aws.sdk.kotlin.services.connect.model.AnswerMachineDetectionConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
