// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.SdkDsl

public class SearchResourceTagsRequest private constructor(builder: Builder) {
    /**
     * The identifier of the Amazon Connect instance. You can find the instanceId in the Amazon Resource Name (ARN) of the instance.
     */
    public val instanceId: kotlin.String? = builder.instanceId
    /**
     * The maximum number of results to return per page.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The list of resource types to be used to search tags from. If not provided or if any empty list is provided, this API will search from all supported resource types.
     */
    public val resourceTypes: List<String>? = builder.resourceTypes
    /**
     * The search criteria to be used to return tags.
     */
    public val searchCriteria: aws.sdk.kotlin.services.connect.model.ResourceTagsSearchCriteria? = builder.searchCriteria

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.SearchResourceTagsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SearchResourceTagsRequest(")
        append("instanceId=$instanceId,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("resourceTypes=$resourceTypes,")
        append("searchCriteria=$searchCriteria")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = instanceId?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (resourceTypes?.hashCode() ?: 0)
        result = 31 * result + (searchCriteria?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SearchResourceTagsRequest

        if (instanceId != other.instanceId) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (resourceTypes != other.resourceTypes) return false
        if (searchCriteria != other.searchCriteria) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.SearchResourceTagsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier of the Amazon Connect instance. You can find the instanceId in the Amazon Resource Name (ARN) of the instance.
         */
        public var instanceId: kotlin.String? = null
        /**
         * The maximum number of results to return per page.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The list of resource types to be used to search tags from. If not provided or if any empty list is provided, this API will search from all supported resource types.
         */
        public var resourceTypes: List<String>? = null
        /**
         * The search criteria to be used to return tags.
         */
        public var searchCriteria: aws.sdk.kotlin.services.connect.model.ResourceTagsSearchCriteria? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.SearchResourceTagsRequest) : this() {
            this.instanceId = x.instanceId
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.resourceTypes = x.resourceTypes
            this.searchCriteria = x.searchCriteria
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.SearchResourceTagsRequest = SearchResourceTagsRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.ResourceTagsSearchCriteria] inside the given [block]
         */
        public fun searchCriteria(block: aws.sdk.kotlin.services.connect.model.ResourceTagsSearchCriteria.Builder.() -> kotlin.Unit) {
            this.searchCriteria = aws.sdk.kotlin.services.connect.model.ResourceTagsSearchCriteria.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
