// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about a hierarchy group.
 */
public class HierarchyGroup private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the hierarchy group.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * Information about the levels in the hierarchy group.
     */
    public val hierarchyPath: aws.sdk.kotlin.services.connect.model.HierarchyPath? = builder.hierarchyPath
    /**
     * The identifier of the hierarchy group.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The Amazon Web Services Region where this resource was last modified.
     */
    public val lastModifiedRegion: kotlin.String? = builder.lastModifiedRegion
    /**
     * The timestamp when this resource was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The identifier of the level in the hierarchy group.
     */
    public val levelId: kotlin.String? = builder.levelId
    /**
     * The name of the hierarchy group.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.HierarchyGroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HierarchyGroup(")
        append("arn=$arn,")
        append("hierarchyPath=$hierarchyPath,")
        append("id=$id,")
        append("lastModifiedRegion=$lastModifiedRegion,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("levelId=$levelId,")
        append("name=$name,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (hierarchyPath?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedRegion?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (levelId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HierarchyGroup

        if (arn != other.arn) return false
        if (hierarchyPath != other.hierarchyPath) return false
        if (id != other.id) return false
        if (lastModifiedRegion != other.lastModifiedRegion) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (levelId != other.levelId) return false
        if (name != other.name) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.HierarchyGroup = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the hierarchy group.
         */
        public var arn: kotlin.String? = null
        /**
         * Information about the levels in the hierarchy group.
         */
        public var hierarchyPath: aws.sdk.kotlin.services.connect.model.HierarchyPath? = null
        /**
         * The identifier of the hierarchy group.
         */
        public var id: kotlin.String? = null
        /**
         * The Amazon Web Services Region where this resource was last modified.
         */
        public var lastModifiedRegion: kotlin.String? = null
        /**
         * The timestamp when this resource was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The identifier of the level in the hierarchy group.
         */
        public var levelId: kotlin.String? = null
        /**
         * The name of the hierarchy group.
         */
        public var name: kotlin.String? = null
        /**
         * The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.HierarchyGroup) : this() {
            this.arn = x.arn
            this.hierarchyPath = x.hierarchyPath
            this.id = x.id
            this.lastModifiedRegion = x.lastModifiedRegion
            this.lastModifiedTime = x.lastModifiedTime
            this.levelId = x.levelId
            this.name = x.name
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.HierarchyGroup = HierarchyGroup(this)

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.HierarchyPath] inside the given [block]
         */
        public fun hierarchyPath(block: aws.sdk.kotlin.services.connect.model.HierarchyPath.Builder.() -> kotlin.Unit) {
            this.hierarchyPath = aws.sdk.kotlin.services.connect.model.HierarchyPath.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
