// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class GetMetricDataV2Request private constructor(builder: Builder) {
    /**
     * The timestamp, in UNIX Epoch time format, at which to end the reporting interval for the retrieval of historical metrics data. The time must be later than the start time timestamp. It cannot be later than the current timestamp.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The filters to apply to returned metrics. You can filter on the following resources:
     * + Agents
     * + Channels
     * + Feature
     * + Queues
     * + Routing profiles
     * + Routing step expression
     * + User hierarchy groups
     *
     * At least one filter must be passed from queues, routing profiles, agents, or user hierarchy groups.
     *
     * To filter by phone number, see [Create a historical metrics report](https://docs.aws.amazon.com/connect/latest/adminguide/create-historical-metrics-report.html) in the *Amazon Connect Administrator Guide*.
     *
     * Note the following limits:
     * + **Filter keys**: A maximum of 5 filter keys are supported in a single request. Valid filter keys: `AGENT` | `AGENT_HIERARCHY_LEVEL_ONE` | `AGENT_HIERARCHY_LEVEL_TWO` | `AGENT_HIERARCHY_LEVEL_THREE` | `AGENT_HIERARCHY_LEVEL_FOUR` | `AGENT_HIERARCHY_LEVEL_FIVE` | `CASE_TEMPLATE_ARN` | `CASE_STATUS` | `CHANNEL` | `contact/segmentAttributes/connect:Subtype` | `FEATURE` | `FLOW_TYPE` | `FLOWS_NEXT_RESOURCE_ID` | `FLOWS_NEXT_RESOURCE_QUEUE_ID` | `FLOWS_OUTCOME_TYPE` | `FLOWS_RESOURCE_ID` | `INITIATION_METHOD` | `RESOURCE_PUBLISHED_TIMESTAMP` | `ROUTING_PROFILE` | `ROUTING_STEP_EXPRESSION` | `QUEUE` | `Q_CONNECT_ENABLED` |
     * + **Filter values**: A maximum of 100 filter values are supported in a single request. VOICE, CHAT, and TASK are valid `filterValue` for the CHANNEL filter key. They do not count towards limitation of 100 filter values. For example, a GetMetricDataV2 request can filter by 50 queues, 35 agents, and 15 routing profiles for a total of 100 filter values, along with 3 channel filters. `contact_lens_conversational_analytics` is a valid filterValue for the `FEATURE` filter key. It is available only to contacts analyzed by Contact Lens conversational analytics.`connect:Chat`, `connect:SMS`, `connect:Telephony`, and `connect:WebRTC` are valid `filterValue` examples (not exhaustive) for the `contact/segmentAttributes/connect:Subtype filter` key.`ROUTING_STEP_EXPRESSION` is a valid filter key with a filter value up to 3000 length. This filter is case and order sensitive. JSON string fields must be sorted in ascending order and JSON array order should be kept as is.`Q_CONNECT_ENABLED`. TRUE and FALSE are the only valid filterValues for the `Q_CONNECT_ENABLED` filter key.
     *    + TRUE includes all contacts that had Amazon Q in Connect enabled as part of the flow.
     *    + FALSE includes all contacts that did not have Amazon Q in Connect enabled as part of the flow
     * This filter is available only for contact record-driven metrics.
     */
    public val filters: List<FilterV2>? = builder.filters
    /**
     * The grouping applied to the metrics that are returned. For example, when results are grouped by queue, the metrics returned are grouped by queue. The values that are returned apply to the metrics for each queue. They are not aggregated for all queues.
     *
     * If no grouping is specified, a summary of all metrics is returned.
     *
     * Valid grouping keys: `AGENT` | `AGENT_HIERARCHY_LEVEL_ONE` | `AGENT_HIERARCHY_LEVEL_TWO` | `AGENT_HIERARCHY_LEVEL_THREE` | `AGENT_HIERARCHY_LEVEL_FOUR` | `AGENT_HIERARCHY_LEVEL_FIVE` | `CASE_TEMPLATE_ARN` | `CASE_STATUS` | `CHANNEL` | `contact/segmentAttributes/connect:Subtype` | `FLOWS_RESOURCE_ID` | `FLOWS_MODULE_RESOURCE_ID` | `FLOW_TYPE` | `FLOWS_OUTCOME_TYPE` | `INITIATION_METHOD` | `Q_CONNECT_ENABLED` | `QUEUE` | `RESOURCE_PUBLISHED_TIMESTAMP` | `ROUTING_PROFILE` | `ROUTING_STEP_EXPRESSION`
     */
    public val groupings: List<String>? = builder.groupings
    /**
     * The interval period and timezone to apply to returned metrics.
     * + `IntervalPeriod`: An aggregated grouping applied to request metrics. Valid `IntervalPeriod` values are: `FIFTEEN_MIN` | `THIRTY_MIN` | `HOUR` | `DAY` | `WEEK` | `TOTAL`. For example, if `IntervalPeriod` is selected `THIRTY_MIN`, `StartTime` and `EndTime` differs by 1 day, then Amazon Connect returns 48 results in the response. Each result is aggregated by the THIRTY_MIN period. By default Amazon Connect aggregates results based on the `TOTAL` interval period. The following list describes restrictions on `StartTime` and `EndTime` based on which `IntervalPeriod` is requested.
     *    + `FIFTEEN_MIN`: The difference between `StartTime` and `EndTime` must be less than 3 days.
     *    + `THIRTY_MIN`: The difference between `StartTime` and `EndTime` must be less than 3 days.
     *    + `HOUR`: The difference between `StartTime` and `EndTime` must be less than 3 days.
     *    + `DAY`: The difference between `StartTime` and `EndTime` must be less than 35 days.
     *    + `WEEK`: The difference between `StartTime` and `EndTime` must be less than 35 days.
     *    + `TOTAL`: The difference between `StartTime` and `EndTime` must be less than 35 days.
     * + `TimeZone`: The timezone applied to requested metrics.
     */
    public val interval: aws.sdk.kotlin.services.connect.model.IntervalDetails? = builder.interval
    /**
     * The maximum number of results to return per page.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The metrics to retrieve. Specify the name, groupings, and filters for each metric. The following historical metrics are available. For a description of each metric, see [Historical metrics definitions](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html) in the *Amazon Connect Administrator Guide*.
     *
     * ## ABANDONMENT_RATE
     * Unit: Percent
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype, Q in Connect
     *
     * UI name: [Abandonment rate](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#abandonment-rate-historical)
     *
     * ## AGENT_ADHERENT_TIME
     * This metric is available only in Amazon Web Services Regions where [Forecasting, capacity planning, and scheduling](https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region) is available.
     *
     * Unit: Seconds
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *
     * UI name: [Adherent time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#adherent-time-historical)
     *
     * ## AGENT_ANSWER_RATE
     * Unit: Percent
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *
     * UI name: [Agent answer rate](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-answer-rate-historical)
     *
     * ## AGENT_NON_ADHERENT_TIME
     * Unit: Seconds
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *
     * UI name: [Non-adherent time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#non-adherent-time)
     *
     * ## AGENT_NON_RESPONSE
     * Unit: Count
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *
     * UI name: [Agent non-response](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-non-response)
     *
     * ## AGENT_NON_RESPONSE_WITHOUT_CUSTOMER_ABANDONS
     * Unit: Count
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *
     * Data for this metric is available starting from October 1, 2023 0:00:00 GMT.
     *
     * UI name: [Agent non-response without customer abandons](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-nonresponse-no-abandon-historical)
     *
     * ## AGENT_OCCUPANCY
     * Unit: Percentage
     *
     * Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
     *
     * UI name: [Occupancy](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#occupancy-historical)
     *
     * ## AGENT_SCHEDULE_ADHERENCE
     * This metric is available only in Amazon Web Services Regions where [Forecasting, capacity planning, and scheduling](https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region) is available.
     *
     * Unit: Percent
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *
     * UI name: [Adherence](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#adherence-historical)
     *
     * ## AGENT_SCHEDULED_TIME
     * This metric is available only in Amazon Web Services Regions where [Forecasting, capacity planning, and scheduling](https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region) is available.
     *
     * Unit: Seconds
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *
     * UI name: [Scheduled time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#scheduled-time-historical)
     *
     * ## AVG_ABANDON_TIME
     * Unit: Seconds
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype, Q in Connect
     *
     * UI name: [Average queue abandon time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-queue-abandon-time-historical)
     *
     * ## AVG_ACTIVE_TIME
     * Unit: Seconds
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
     *
     * UI name: [Average active time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-active-time-historical)
     *
     * ## AVG_AFTER_CONTACT_WORK_TIME
     * Unit: Seconds
     *
     * Valid metric filter key: `INITIATION_METHOD`
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype, Q in Connect
     *
     * UI name: [Average after contact work time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-acw-time-historical)
     *
     * Feature is a valid filter but not a valid grouping.
     *
     * ## AVG_AGENT_CONNECTING_TIME
     * Unit: Seconds
     *
     * Valid metric filter key: `INITIATION_METHOD`. For now, this metric only supports the following as `INITIATION_METHOD`: `INBOUND` | `OUTBOUND` | `CALLBACK` | `API`
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *
     * UI name: [Average agent API connecting time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#htm-avg-agent-api-connecting-time)
     *
     * The `Negate` key in Metric Level Filters is not applicable for this metric.
     *
     * ## AVG_AGENT_PAUSE_TIME
     * Unit: Seconds
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
     *
     * UI name: [Average agent pause time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-agent-pause-time-historical)
     *
     * ## AVG_CASE_RELATED_CONTACTS
     * Unit: Count
     *
     * Required filter key: CASE_TEMPLATE_ARN
     *
     * Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
     *
     * UI name: [Average contacts per case](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-contacts-case-historical)
     *
     * ## AVG_CASE_RESOLUTION_TIME
     * Unit: Seconds
     *
     * Required filter key: CASE_TEMPLATE_ARN
     *
     * Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
     *
     * UI name: [Average case resolution time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-case-resolution-time-historical)
     *
     * ## AVG_CONTACT_DURATION
     * Unit: Seconds
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype, Q in Connect
     *
     * UI name: [Average contact duration](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-contact-duration-historical)
     *
     * Feature is a valid filter but not a valid grouping.
     *
     * ## AVG_CONVERSATION_DURATION
     * Unit: Seconds
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype, Q in Connect
     *
     * UI name: [Average conversation duration](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-conversation-duration-historical)
     *
     * ## AVG_FLOW_TIME
     * Unit: Seconds
     *
     * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows module resource ID, Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows resource ID, Initiation method, Resource published timestamp
     *
     * UI name: [Average flow time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-flow-time-historical)
     *
     * ## AVG_GREETING_TIME_AGENT
     * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
     *
     * Unit: Seconds
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
     *
     * UI name: [Average agent greeting time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-greeting-time-agent-historical)
     *
     * ## AVG_HANDLE_TIME
     * Unit: Seconds
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype, RoutingStepExpression
     *
     * UI name: [Average handle time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-handle-time-historical)
     *
     * Feature is a valid filter but not a valid grouping.
     *
     * ## AVG_HOLD_TIME
     * Unit: Seconds
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype, Q in Connect
     *
     * UI name: [Average customer hold time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-customer-hold-time-historical)
     *
     * Feature is a valid filter but not a valid grouping.
     *
     * ## AVG_HOLD_TIME_ALL_CONTACTS
     * Unit: Seconds
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
     *
     * UI name: [Average customer hold time all contacts](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#avg-customer-hold-time-all-contacts-historical)
     *
     * ## AVG_HOLDS
     * Unit: Count
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype, Q in Connect
     *
     * UI name: [Average holds](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-holds-historical)
     *
     * Feature is a valid filter but not a valid grouping.
     *
     * ## AVG_INTERACTION_AND_HOLD_TIME
     * Unit: Seconds
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
     *
     * UI name: [Average agent interaction and customer hold time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-agent-interaction-customer-hold-time-historical)
     *
     * ## AVG_INTERACTION_TIME
     * Unit: Seconds
     *
     * Valid metric filter key: `INITIATION_METHOD`
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Feature, contact/segmentAttributes/connect:Subtype, Q in Connect
     *
     * UI name: [Average agent interaction time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-agent-interaction-time-historical)
     *
     * Feature is a valid filter but not a valid grouping.
     *
     * ## AVG_INTERRUPTIONS_AGENT
     * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
     *
     * Unit: Count
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
     *
     * UI name: [Average agent interruptions](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-interruptions-agent-historical)
     *
     * ## AVG_INTERRUPTION_TIME_AGENT
     * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
     *
     * Unit: Seconds
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
     *
     * UI name: [Average agent interruption time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-interruptions-time-agent-historical)
     *
     * ## AVG_NON_TALK_TIME
     * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
     *
     * Unit: Seconds
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
     *
     * UI name: [Average non-talk time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html##average-non-talk-time-historical)
     *
     * ## AVG_QUEUE_ANSWER_TIME
     * Unit: Seconds
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Feature, contact/segmentAttributes/connect:Subtype, Q in Connect
     *
     * UI name: [Average queue answer time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-queue-answer-time-historical)
     *
     * Feature is a valid filter but not a valid grouping.
     *
     * ## AVG_RESOLUTION_TIME
     * Unit: Seconds
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, contact/segmentAttributes/connect:Subtype, Q in Connect
     *
     * UI name: [Average resolution time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-resolution-time-historical)
     *
     * ## AVG_TALK_TIME
     * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
     *
     * Unit: Seconds
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
     *
     * UI name: [Average talk time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-talk-time-historical)
     *
     * ## AVG_TALK_TIME_AGENT
     * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
     *
     * Unit: Seconds
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
     *
     * UI name: [Average agent talk time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-talk-time-agent-historical)
     *
     * ## AVG_TALK_TIME_CUSTOMER
     * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
     *
     * Unit: Seconds
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
     *
     * UI name: [Average customer talk time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-talk-time-customer-historical)
     *
     * ## CASES_CREATED
     * Unit: Count
     *
     * Required filter key: CASE_TEMPLATE_ARN
     *
     * Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
     *
     * UI name: [Cases created](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html##cases-created-historical)
     *
     * ## CONTACTS_CREATED
     * Unit: Count
     *
     * Valid metric filter key: `INITIATION_METHOD`
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Feature, contact/segmentAttributes/connect:Subtype, Q in Connect
     *
     * UI name: [Contacts created](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-created-historical)
     *
     * Feature is a valid filter but not a valid grouping.
     *
     * ## CONTACTS_HANDLED
     * Unit: Count
     *
     * Valid metric filter key: `INITIATION_METHOD`, `DISCONNECT_REASON`
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype, RoutingStepExpression, Q in Connect
     *
     * UI name: [API contacts handled](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#api-contacts-handled-historical)
     *
     * Feature is a valid filter but not a valid grouping.
     *
     * ## CONTACTS_HANDLED_BY_CONNECTED_TO_AGENT
     * Unit: Count
     *
     * Valid metric filter key: `INITIATION_METHOD`
     *
     * Valid groupings and filters: Queue, Channel, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
     *
     * UI name: [Contacts handled (connected to agent timestamp)](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-handled-by-connected-to-agent-historical)
     *
     * ## CONTACTS_HOLD_ABANDONS
     * Unit: Count
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
     *
     * UI name: [Contacts hold disconnect](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-handled-by-connected-to-agent-historical)
     *
     * ## CONTACTS_ON_HOLD_AGENT_DISCONNECT
     * Unit: Count
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
     *
     * UI name: [Contacts hold agent disconnect](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-hold-agent-disconnect-historical)
     *
     * ## CONTACTS_ON_HOLD_CUSTOMER_DISCONNECT
     * Unit: Count
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
     *
     * UI name: [Contacts hold customer disconnect](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-hold-customer-disconnect-historical)
     *
     * ## CONTACTS_PUT_ON_HOLD
     * Unit: Count
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
     *
     * UI name: [Contacts put on hold](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-hold-customer-disconnect-historical)
     *
     * ## CONTACTS_TRANSFERRED_OUT_EXTERNAL
     * Unit: Count
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
     *
     * UI name: [Contacts transferred out external](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-external-historical)
     *
     * ## CONTACTS_TRANSFERRED_OUT_INTERNAL
     * Unit: Percent
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
     *
     * UI name: [Contacts transferred out internal](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-internal-historical)
     *
     * ## CONTACTS_QUEUED
     * Unit: Count
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
     *
     * UI name: [Contacts queued](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-queued-historical)
     *
     * ## CONTACTS_QUEUED_BY_ENQUEUE
     * Unit: Count
     *
     * Valid groupings and filters: Queue, Channel, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype
     *
     * UI name: [Contacts queued (enqueue timestamp)](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-queued-by-enqueue-historical)
     *
     * ## CONTACTS_REMOVED_FROM_QUEUE_IN_X
     * Unit: Count
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Q in Connect
     *
     * Threshold: For `ThresholdValue`, enter any whole number from 1 to 604800 (inclusive), in seconds. For `Comparison`, you must enter `LT` (for "Less than").
     *
     * UI name: This metric is not available in Amazon Connect admin website.
     *
     * ## CONTACTS_RESOLVED_IN_X
     * Unit: Count
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, contact/segmentAttributes/connect:Subtype, Q in Connect
     *
     * Threshold: For `ThresholdValue` enter any whole number from 1 to 604800 (inclusive), in seconds. For `Comparison`, you must enter `LT` (for "Less than").
     *
     * UI name: [Contacts resolved in X](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-resolved-historical)
     *
     * ## CONTACTS_TRANSFERRED_OUT
     * Unit: Count
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype, Q in Connect
     *
     * UI name: [Contacts transferred out](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-historical)
     *
     * Feature is a valid filter but not a valid grouping.
     *
     * ## CONTACTS_TRANSFERRED_OUT_BY_AGENT
     * Unit: Count
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
     *
     * UI name: [Contacts transferred out by agent](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-by-agent-historical)
     *
     * ## CONTACTS_TRANSFERRED_OUT_FROM_QUEUE
     * Unit: Count
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
     *
     * UI name: [Contacts transferred out queue](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-by-agent-historical)
     *
     * ## CURRENT_CASES
     * Unit: Count
     *
     * Required filter key: CASE_TEMPLATE_ARN
     *
     * Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
     *
     * UI name: [Current cases](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#current-cases-historical)
     *
     * ## FLOWS_OUTCOME
     * Unit: Count
     *
     * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows module resource ID, Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows resource ID, Initiation method, Resource published timestamp
     *
     * UI name: [Flows outcome](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#flows-outcome-historical)
     *
     * ## FLOWS_STARTED
     * Unit: Count
     *
     * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows module resource ID, Flows resource ID, Initiation method, Resource published timestamp
     *
     * UI name: [Flows started](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#flows-started-historical)
     *
     * ## MAX_FLOW_TIME
     * Unit: Seconds
     *
     * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows module resource ID, Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows resource ID, Initiation method, Resource published timestamp
     *
     * UI name: [Maximum flow time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#maximum-flow-time-historical)
     *
     * ## MAX_QUEUED_TIME
     * Unit: Seconds
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
     *
     * UI name: [Maximum queued time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#maximum-queued-time-historical)
     *
     * ## MIN_FLOW_TIME
     * Unit: Seconds
     *
     * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows module resource ID, Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows resource ID, Initiation method, Resource published timestamp
     *
     * UI name: [Minimum flow time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#minimum-flow-time-historical)
     *
     * ## PERCENT_CASES_FIRST_CONTACT_RESOLVED
     * Unit: Percent
     *
     * Required filter key: CASE_TEMPLATE_ARN
     *
     * Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
     *
     * UI name: [Cases resolved on first contact](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#cases-resolved-first-contact-historical)
     *
     * ## PERCENT_CONTACTS_STEP_EXPIRED
     * Unit: Percent
     *
     * Valid groupings and filters: Queue, RoutingStepExpression
     *
     * UI name: This metric is available in Real-time Metrics UI but not on the Historical Metrics UI.
     *
     * ## PERCENT_CONTACTS_STEP_JOINED
     * Unit: Percent
     *
     * Valid groupings and filters: Queue, RoutingStepExpression
     *
     * UI name: This metric is available in Real-time Metrics UI but not on the Historical Metrics UI.
     *
     * ## PERCENT_FLOWS_OUTCOME
     * Unit: Percent
     *
     * Valid metric filter key: `FLOWS_OUTCOME_TYPE`
     *
     * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows module resource ID, Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows resource ID, Initiation method, Resource published timestamp
     *
     * UI name: [Flows outcome percentage](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#flows-outcome-percentage-historical).
     *
     * The `FLOWS_OUTCOME_TYPE` is not a valid grouping.
     *
     * ## PERCENT_NON_TALK_TIME
     * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
     *
     * Unit: Percentage
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
     *
     * UI name: [Non-talk time percent](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#ntt-historical)
     *
     * ## PERCENT_TALK_TIME
     * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
     *
     * Unit: Percentage
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
     *
     * UI name: [Talk time percent](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#tt-historical)
     *
     * ## PERCENT_TALK_TIME_AGENT
     * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
     *
     * Unit: Percentage
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
     *
     * UI name: [Agent talk time percent](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#ttagent-historical)
     *
     * ## PERCENT_TALK_TIME_CUSTOMER
     * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
     *
     * Unit: Percentage
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
     *
     * UI name: [Customer talk time percent](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#ttcustomer-historical)
     *
     * ## REOPENED_CASE_ACTIONS
     * Unit: Count
     *
     * Required filter key: CASE_TEMPLATE_ARN
     *
     * Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
     *
     * UI name: [Cases reopened](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#cases-reopened-historical)
     *
     * ## RESOLVED_CASE_ACTIONS
     * Unit: Count
     *
     * Required filter key: CASE_TEMPLATE_ARN
     *
     * Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
     *
     * UI name: [Cases resolved](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#cases-resolved-historical)
     *
     * ## SERVICE_LEVEL
     * You can include up to 20 SERVICE_LEVEL metrics in a request.
     *
     * Unit: Percent
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Q in Connect
     *
     * Threshold: For `ThresholdValue`, enter any whole number from 1 to 604800 (inclusive), in seconds. For `Comparison`, you must enter `LT` (for "Less than").
     *
     * UI name: [Service level X](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#service-level-historical)
     *
     * ## STEP_CONTACTS_QUEUED
     * Unit: Count
     *
     * Valid groupings and filters: Queue, RoutingStepExpression
     *
     * UI name: This metric is available in Real-time Metrics UI but not on the Historical Metrics UI.
     *
     * ## SUM_AFTER_CONTACT_WORK_TIME
     * Unit: Seconds
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
     *
     * UI name: [After contact work time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#acw-historical)
     *
     * ## SUM_CONNECTING_TIME_AGENT
     * Unit: Seconds
     *
     * Valid metric filter key: `INITIATION_METHOD`. This metric only supports the following filter keys as `INITIATION_METHOD`: `INBOUND` | `OUTBOUND` | `CALLBACK` | `API`
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *
     * UI name: [Agent API connecting time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#htm-agent-api-connecting-time)
     *
     * The `Negate` key in Metric Level Filters is not applicable for this metric.
     *
     * ## SUM_CONTACTS_ABANDONED
     * Unit: Count
     *
     * Metric filter:
     * + Valid values: `API`| `Incoming` | `Outbound` | `Transfer` | `Callback` | `Queue_Transfer`| `Disconnect`
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, RoutingStepExpression, Q in Connect
     *
     * UI name: [Contact abandoned](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-abandoned-historical)
     *
     * ## SUM_CONTACTS_ABANDONED_IN_X
     * Unit: Count
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, contact/segmentAttributes/connect:Subtype, Q in Connect
     *
     * Threshold: For `ThresholdValue`, enter any whole number from 1 to 604800 (inclusive), in seconds. For `Comparison`, you must enter `LT` (for "Less than").
     *
     * UI name: [Contacts abandoned in X seconds](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-abandoned-x-historical)
     *
     * ## SUM_CONTACTS_ANSWERED_IN_X
     * Unit: Count
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, contact/segmentAttributes/connect:Subtype, Q in Connect
     *
     * Threshold: For `ThresholdValue`, enter any whole number from 1 to 604800 (inclusive), in seconds. For `Comparison`, you must enter `LT` (for "Less than").
     *
     * UI name: [Contacts answered in X seconds](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-answered-x-historical)
     *
     * ## SUM_CONTACT_FLOW_TIME
     * Unit: Seconds
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
     *
     * UI name: [Contact flow time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contact-flow-time-historical)
     *
     * ## SUM_CONTACT_TIME_AGENT
     * Unit: Seconds
     *
     * Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
     *
     * UI name: [Agent on contact time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-on-contact-time-historical)
     *
     * ## SUM_CONTACTS_DISCONNECTED
     * Valid metric filter key: `DISCONNECT_REASON`
     *
     * Unit: Count
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
     *
     * UI name: [Contact disconnected](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contact-disconnected-historical)
     *
     * ## SUM_ERROR_STATUS_TIME_AGENT
     * Unit: Seconds
     *
     * Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
     *
     * UI name: [Error status time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#error-status-time-historical)
     *
     * ## SUM_HANDLE_TIME
     * Unit: Seconds
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
     *
     * UI name: [Contact handle time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contact-handle-time-historical)
     *
     * ## SUM_HOLD_TIME
     * Unit: Count
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
     *
     * UI name: [Customer hold time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#customer-hold-time-historical)
     *
     * ## SUM_IDLE_TIME_AGENT
     * Unit: Seconds
     *
     * Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
     *
     * UI name: [Agent idle time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-idle-time-historica)
     *
     * ## SUM_INTERACTION_AND_HOLD_TIME
     * Unit: Seconds
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
     *
     * UI name: [Agent interaction and hold time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-interaction-hold-time-historical)
     *
     * ## SUM_INTERACTION_TIME
     * Unit: Seconds
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *
     * UI name: [Agent interaction time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-interaction-time-historical)
     *
     * ## SUM_NON_PRODUCTIVE_TIME_AGENT
     * Unit: Seconds
     *
     * Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
     *
     * UI name: [Non-Productive Time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#npt-historical)
     *
     * ## SUM_ONLINE_TIME_AGENT
     * Unit: Seconds
     *
     * Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
     *
     * UI name: [Online time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#online-time-historical)
     *
     * ## SUM_RETRY_CALLBACK_ATTEMPTS
     * Unit: Count
     *
     * Valid groupings and filters: Queue, Channel, Routing Profile, contact/segmentAttributes/connect:Subtype, Q in Connect
     *
     * UI name: [Callback attempts](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#callback-attempts-historical)
     */
    public val metrics: List<MetricV2>? = builder.metrics
    /**
     * The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The Amazon Resource Name (ARN) of the resource. This includes the `instanceId` an Amazon Connect instance.
     */
    public val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * The timestamp, in UNIX Epoch time format, at which to start the reporting interval for the retrieval of historical metrics data. The time must be before the end time timestamp. The start and end time depends on the `IntervalPeriod` selected. By default the time range between start and end time is 35 days. Historical metrics are available for 3 months.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.GetMetricDataV2Request = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetMetricDataV2Request(")
        append("endTime=$endTime,")
        append("filters=$filters,")
        append("groupings=$groupings,")
        append("interval=$interval,")
        append("maxResults=$maxResults,")
        append("metrics=$metrics,")
        append("nextToken=$nextToken,")
        append("resourceArn=$resourceArn,")
        append("startTime=$startTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (groupings?.hashCode() ?: 0)
        result = 31 * result + (interval?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (metrics?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetMetricDataV2Request

        if (endTime != other.endTime) return false
        if (filters != other.filters) return false
        if (groupings != other.groupings) return false
        if (interval != other.interval) return false
        if (maxResults != other.maxResults) return false
        if (metrics != other.metrics) return false
        if (nextToken != other.nextToken) return false
        if (resourceArn != other.resourceArn) return false
        if (startTime != other.startTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.GetMetricDataV2Request = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The timestamp, in UNIX Epoch time format, at which to end the reporting interval for the retrieval of historical metrics data. The time must be later than the start time timestamp. It cannot be later than the current timestamp.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The filters to apply to returned metrics. You can filter on the following resources:
         * + Agents
         * + Channels
         * + Feature
         * + Queues
         * + Routing profiles
         * + Routing step expression
         * + User hierarchy groups
         *
         * At least one filter must be passed from queues, routing profiles, agents, or user hierarchy groups.
         *
         * To filter by phone number, see [Create a historical metrics report](https://docs.aws.amazon.com/connect/latest/adminguide/create-historical-metrics-report.html) in the *Amazon Connect Administrator Guide*.
         *
         * Note the following limits:
         * + **Filter keys**: A maximum of 5 filter keys are supported in a single request. Valid filter keys: `AGENT` | `AGENT_HIERARCHY_LEVEL_ONE` | `AGENT_HIERARCHY_LEVEL_TWO` | `AGENT_HIERARCHY_LEVEL_THREE` | `AGENT_HIERARCHY_LEVEL_FOUR` | `AGENT_HIERARCHY_LEVEL_FIVE` | `CASE_TEMPLATE_ARN` | `CASE_STATUS` | `CHANNEL` | `contact/segmentAttributes/connect:Subtype` | `FEATURE` | `FLOW_TYPE` | `FLOWS_NEXT_RESOURCE_ID` | `FLOWS_NEXT_RESOURCE_QUEUE_ID` | `FLOWS_OUTCOME_TYPE` | `FLOWS_RESOURCE_ID` | `INITIATION_METHOD` | `RESOURCE_PUBLISHED_TIMESTAMP` | `ROUTING_PROFILE` | `ROUTING_STEP_EXPRESSION` | `QUEUE` | `Q_CONNECT_ENABLED` |
         * + **Filter values**: A maximum of 100 filter values are supported in a single request. VOICE, CHAT, and TASK are valid `filterValue` for the CHANNEL filter key. They do not count towards limitation of 100 filter values. For example, a GetMetricDataV2 request can filter by 50 queues, 35 agents, and 15 routing profiles for a total of 100 filter values, along with 3 channel filters. `contact_lens_conversational_analytics` is a valid filterValue for the `FEATURE` filter key. It is available only to contacts analyzed by Contact Lens conversational analytics.`connect:Chat`, `connect:SMS`, `connect:Telephony`, and `connect:WebRTC` are valid `filterValue` examples (not exhaustive) for the `contact/segmentAttributes/connect:Subtype filter` key.`ROUTING_STEP_EXPRESSION` is a valid filter key with a filter value up to 3000 length. This filter is case and order sensitive. JSON string fields must be sorted in ascending order and JSON array order should be kept as is.`Q_CONNECT_ENABLED`. TRUE and FALSE are the only valid filterValues for the `Q_CONNECT_ENABLED` filter key.
         *    + TRUE includes all contacts that had Amazon Q in Connect enabled as part of the flow.
         *    + FALSE includes all contacts that did not have Amazon Q in Connect enabled as part of the flow
         * This filter is available only for contact record-driven metrics.
         */
        public var filters: List<FilterV2>? = null
        /**
         * The grouping applied to the metrics that are returned. For example, when results are grouped by queue, the metrics returned are grouped by queue. The values that are returned apply to the metrics for each queue. They are not aggregated for all queues.
         *
         * If no grouping is specified, a summary of all metrics is returned.
         *
         * Valid grouping keys: `AGENT` | `AGENT_HIERARCHY_LEVEL_ONE` | `AGENT_HIERARCHY_LEVEL_TWO` | `AGENT_HIERARCHY_LEVEL_THREE` | `AGENT_HIERARCHY_LEVEL_FOUR` | `AGENT_HIERARCHY_LEVEL_FIVE` | `CASE_TEMPLATE_ARN` | `CASE_STATUS` | `CHANNEL` | `contact/segmentAttributes/connect:Subtype` | `FLOWS_RESOURCE_ID` | `FLOWS_MODULE_RESOURCE_ID` | `FLOW_TYPE` | `FLOWS_OUTCOME_TYPE` | `INITIATION_METHOD` | `Q_CONNECT_ENABLED` | `QUEUE` | `RESOURCE_PUBLISHED_TIMESTAMP` | `ROUTING_PROFILE` | `ROUTING_STEP_EXPRESSION`
         */
        public var groupings: List<String>? = null
        /**
         * The interval period and timezone to apply to returned metrics.
         * + `IntervalPeriod`: An aggregated grouping applied to request metrics. Valid `IntervalPeriod` values are: `FIFTEEN_MIN` | `THIRTY_MIN` | `HOUR` | `DAY` | `WEEK` | `TOTAL`. For example, if `IntervalPeriod` is selected `THIRTY_MIN`, `StartTime` and `EndTime` differs by 1 day, then Amazon Connect returns 48 results in the response. Each result is aggregated by the THIRTY_MIN period. By default Amazon Connect aggregates results based on the `TOTAL` interval period. The following list describes restrictions on `StartTime` and `EndTime` based on which `IntervalPeriod` is requested.
         *    + `FIFTEEN_MIN`: The difference between `StartTime` and `EndTime` must be less than 3 days.
         *    + `THIRTY_MIN`: The difference between `StartTime` and `EndTime` must be less than 3 days.
         *    + `HOUR`: The difference between `StartTime` and `EndTime` must be less than 3 days.
         *    + `DAY`: The difference between `StartTime` and `EndTime` must be less than 35 days.
         *    + `WEEK`: The difference between `StartTime` and `EndTime` must be less than 35 days.
         *    + `TOTAL`: The difference between `StartTime` and `EndTime` must be less than 35 days.
         * + `TimeZone`: The timezone applied to requested metrics.
         */
        public var interval: aws.sdk.kotlin.services.connect.model.IntervalDetails? = null
        /**
         * The maximum number of results to return per page.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The metrics to retrieve. Specify the name, groupings, and filters for each metric. The following historical metrics are available. For a description of each metric, see [Historical metrics definitions](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html) in the *Amazon Connect Administrator Guide*.
         *
         * ## ABANDONMENT_RATE
         * Unit: Percent
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype, Q in Connect
         *
         * UI name: [Abandonment rate](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#abandonment-rate-historical)
         *
         * ## AGENT_ADHERENT_TIME
         * This metric is available only in Amazon Web Services Regions where [Forecasting, capacity planning, and scheduling](https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region) is available.
         *
         * Unit: Seconds
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *
         * UI name: [Adherent time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#adherent-time-historical)
         *
         * ## AGENT_ANSWER_RATE
         * Unit: Percent
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *
         * UI name: [Agent answer rate](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-answer-rate-historical)
         *
         * ## AGENT_NON_ADHERENT_TIME
         * Unit: Seconds
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *
         * UI name: [Non-adherent time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#non-adherent-time)
         *
         * ## AGENT_NON_RESPONSE
         * Unit: Count
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *
         * UI name: [Agent non-response](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-non-response)
         *
         * ## AGENT_NON_RESPONSE_WITHOUT_CUSTOMER_ABANDONS
         * Unit: Count
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *
         * Data for this metric is available starting from October 1, 2023 0:00:00 GMT.
         *
         * UI name: [Agent non-response without customer abandons](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-nonresponse-no-abandon-historical)
         *
         * ## AGENT_OCCUPANCY
         * Unit: Percentage
         *
         * Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
         *
         * UI name: [Occupancy](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#occupancy-historical)
         *
         * ## AGENT_SCHEDULE_ADHERENCE
         * This metric is available only in Amazon Web Services Regions where [Forecasting, capacity planning, and scheduling](https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region) is available.
         *
         * Unit: Percent
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *
         * UI name: [Adherence](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#adherence-historical)
         *
         * ## AGENT_SCHEDULED_TIME
         * This metric is available only in Amazon Web Services Regions where [Forecasting, capacity planning, and scheduling](https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region) is available.
         *
         * Unit: Seconds
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *
         * UI name: [Scheduled time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#scheduled-time-historical)
         *
         * ## AVG_ABANDON_TIME
         * Unit: Seconds
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype, Q in Connect
         *
         * UI name: [Average queue abandon time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-queue-abandon-time-historical)
         *
         * ## AVG_ACTIVE_TIME
         * Unit: Seconds
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         *
         * UI name: [Average active time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-active-time-historical)
         *
         * ## AVG_AFTER_CONTACT_WORK_TIME
         * Unit: Seconds
         *
         * Valid metric filter key: `INITIATION_METHOD`
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype, Q in Connect
         *
         * UI name: [Average after contact work time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-acw-time-historical)
         *
         * Feature is a valid filter but not a valid grouping.
         *
         * ## AVG_AGENT_CONNECTING_TIME
         * Unit: Seconds
         *
         * Valid metric filter key: `INITIATION_METHOD`. For now, this metric only supports the following as `INITIATION_METHOD`: `INBOUND` | `OUTBOUND` | `CALLBACK` | `API`
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *
         * UI name: [Average agent API connecting time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#htm-avg-agent-api-connecting-time)
         *
         * The `Negate` key in Metric Level Filters is not applicable for this metric.
         *
         * ## AVG_AGENT_PAUSE_TIME
         * Unit: Seconds
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         *
         * UI name: [Average agent pause time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-agent-pause-time-historical)
         *
         * ## AVG_CASE_RELATED_CONTACTS
         * Unit: Count
         *
         * Required filter key: CASE_TEMPLATE_ARN
         *
         * Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
         *
         * UI name: [Average contacts per case](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-contacts-case-historical)
         *
         * ## AVG_CASE_RESOLUTION_TIME
         * Unit: Seconds
         *
         * Required filter key: CASE_TEMPLATE_ARN
         *
         * Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
         *
         * UI name: [Average case resolution time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-case-resolution-time-historical)
         *
         * ## AVG_CONTACT_DURATION
         * Unit: Seconds
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype, Q in Connect
         *
         * UI name: [Average contact duration](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-contact-duration-historical)
         *
         * Feature is a valid filter but not a valid grouping.
         *
         * ## AVG_CONVERSATION_DURATION
         * Unit: Seconds
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype, Q in Connect
         *
         * UI name: [Average conversation duration](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-conversation-duration-historical)
         *
         * ## AVG_FLOW_TIME
         * Unit: Seconds
         *
         * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows module resource ID, Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows resource ID, Initiation method, Resource published timestamp
         *
         * UI name: [Average flow time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-flow-time-historical)
         *
         * ## AVG_GREETING_TIME_AGENT
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         *
         * Unit: Seconds
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
         *
         * UI name: [Average agent greeting time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-greeting-time-agent-historical)
         *
         * ## AVG_HANDLE_TIME
         * Unit: Seconds
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype, RoutingStepExpression
         *
         * UI name: [Average handle time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-handle-time-historical)
         *
         * Feature is a valid filter but not a valid grouping.
         *
         * ## AVG_HOLD_TIME
         * Unit: Seconds
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype, Q in Connect
         *
         * UI name: [Average customer hold time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-customer-hold-time-historical)
         *
         * Feature is a valid filter but not a valid grouping.
         *
         * ## AVG_HOLD_TIME_ALL_CONTACTS
         * Unit: Seconds
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
         *
         * UI name: [Average customer hold time all contacts](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#avg-customer-hold-time-all-contacts-historical)
         *
         * ## AVG_HOLDS
         * Unit: Count
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype, Q in Connect
         *
         * UI name: [Average holds](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-holds-historical)
         *
         * Feature is a valid filter but not a valid grouping.
         *
         * ## AVG_INTERACTION_AND_HOLD_TIME
         * Unit: Seconds
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
         *
         * UI name: [Average agent interaction and customer hold time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-agent-interaction-customer-hold-time-historical)
         *
         * ## AVG_INTERACTION_TIME
         * Unit: Seconds
         *
         * Valid metric filter key: `INITIATION_METHOD`
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Feature, contact/segmentAttributes/connect:Subtype, Q in Connect
         *
         * UI name: [Average agent interaction time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-agent-interaction-time-historical)
         *
         * Feature is a valid filter but not a valid grouping.
         *
         * ## AVG_INTERRUPTIONS_AGENT
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         *
         * Unit: Count
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
         *
         * UI name: [Average agent interruptions](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-interruptions-agent-historical)
         *
         * ## AVG_INTERRUPTION_TIME_AGENT
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         *
         * Unit: Seconds
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
         *
         * UI name: [Average agent interruption time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-interruptions-time-agent-historical)
         *
         * ## AVG_NON_TALK_TIME
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         *
         * Unit: Seconds
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
         *
         * UI name: [Average non-talk time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html##average-non-talk-time-historical)
         *
         * ## AVG_QUEUE_ANSWER_TIME
         * Unit: Seconds
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Feature, contact/segmentAttributes/connect:Subtype, Q in Connect
         *
         * UI name: [Average queue answer time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-queue-answer-time-historical)
         *
         * Feature is a valid filter but not a valid grouping.
         *
         * ## AVG_RESOLUTION_TIME
         * Unit: Seconds
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, contact/segmentAttributes/connect:Subtype, Q in Connect
         *
         * UI name: [Average resolution time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-resolution-time-historical)
         *
         * ## AVG_TALK_TIME
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         *
         * Unit: Seconds
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
         *
         * UI name: [Average talk time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-talk-time-historical)
         *
         * ## AVG_TALK_TIME_AGENT
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         *
         * Unit: Seconds
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
         *
         * UI name: [Average agent talk time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-talk-time-agent-historical)
         *
         * ## AVG_TALK_TIME_CUSTOMER
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         *
         * Unit: Seconds
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
         *
         * UI name: [Average customer talk time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-talk-time-customer-historical)
         *
         * ## CASES_CREATED
         * Unit: Count
         *
         * Required filter key: CASE_TEMPLATE_ARN
         *
         * Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
         *
         * UI name: [Cases created](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html##cases-created-historical)
         *
         * ## CONTACTS_CREATED
         * Unit: Count
         *
         * Valid metric filter key: `INITIATION_METHOD`
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Feature, contact/segmentAttributes/connect:Subtype, Q in Connect
         *
         * UI name: [Contacts created](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-created-historical)
         *
         * Feature is a valid filter but not a valid grouping.
         *
         * ## CONTACTS_HANDLED
         * Unit: Count
         *
         * Valid metric filter key: `INITIATION_METHOD`, `DISCONNECT_REASON`
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype, RoutingStepExpression, Q in Connect
         *
         * UI name: [API contacts handled](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#api-contacts-handled-historical)
         *
         * Feature is a valid filter but not a valid grouping.
         *
         * ## CONTACTS_HANDLED_BY_CONNECTED_TO_AGENT
         * Unit: Count
         *
         * Valid metric filter key: `INITIATION_METHOD`
         *
         * Valid groupings and filters: Queue, Channel, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
         *
         * UI name: [Contacts handled (connected to agent timestamp)](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-handled-by-connected-to-agent-historical)
         *
         * ## CONTACTS_HOLD_ABANDONS
         * Unit: Count
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
         *
         * UI name: [Contacts hold disconnect](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-handled-by-connected-to-agent-historical)
         *
         * ## CONTACTS_ON_HOLD_AGENT_DISCONNECT
         * Unit: Count
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         *
         * UI name: [Contacts hold agent disconnect](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-hold-agent-disconnect-historical)
         *
         * ## CONTACTS_ON_HOLD_CUSTOMER_DISCONNECT
         * Unit: Count
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         *
         * UI name: [Contacts hold customer disconnect](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-hold-customer-disconnect-historical)
         *
         * ## CONTACTS_PUT_ON_HOLD
         * Unit: Count
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         *
         * UI name: [Contacts put on hold](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-hold-customer-disconnect-historical)
         *
         * ## CONTACTS_TRANSFERRED_OUT_EXTERNAL
         * Unit: Count
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         *
         * UI name: [Contacts transferred out external](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-external-historical)
         *
         * ## CONTACTS_TRANSFERRED_OUT_INTERNAL
         * Unit: Percent
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         *
         * UI name: [Contacts transferred out internal](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-internal-historical)
         *
         * ## CONTACTS_QUEUED
         * Unit: Count
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
         *
         * UI name: [Contacts queued](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-queued-historical)
         *
         * ## CONTACTS_QUEUED_BY_ENQUEUE
         * Unit: Count
         *
         * Valid groupings and filters: Queue, Channel, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype
         *
         * UI name: [Contacts queued (enqueue timestamp)](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-queued-by-enqueue-historical)
         *
         * ## CONTACTS_REMOVED_FROM_QUEUE_IN_X
         * Unit: Count
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Q in Connect
         *
         * Threshold: For `ThresholdValue`, enter any whole number from 1 to 604800 (inclusive), in seconds. For `Comparison`, you must enter `LT` (for "Less than").
         *
         * UI name: This metric is not available in Amazon Connect admin website.
         *
         * ## CONTACTS_RESOLVED_IN_X
         * Unit: Count
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, contact/segmentAttributes/connect:Subtype, Q in Connect
         *
         * Threshold: For `ThresholdValue` enter any whole number from 1 to 604800 (inclusive), in seconds. For `Comparison`, you must enter `LT` (for "Less than").
         *
         * UI name: [Contacts resolved in X](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-resolved-historical)
         *
         * ## CONTACTS_TRANSFERRED_OUT
         * Unit: Count
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype, Q in Connect
         *
         * UI name: [Contacts transferred out](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-historical)
         *
         * Feature is a valid filter but not a valid grouping.
         *
         * ## CONTACTS_TRANSFERRED_OUT_BY_AGENT
         * Unit: Count
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
         *
         * UI name: [Contacts transferred out by agent](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-by-agent-historical)
         *
         * ## CONTACTS_TRANSFERRED_OUT_FROM_QUEUE
         * Unit: Count
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
         *
         * UI name: [Contacts transferred out queue](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-by-agent-historical)
         *
         * ## CURRENT_CASES
         * Unit: Count
         *
         * Required filter key: CASE_TEMPLATE_ARN
         *
         * Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
         *
         * UI name: [Current cases](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#current-cases-historical)
         *
         * ## FLOWS_OUTCOME
         * Unit: Count
         *
         * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows module resource ID, Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows resource ID, Initiation method, Resource published timestamp
         *
         * UI name: [Flows outcome](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#flows-outcome-historical)
         *
         * ## FLOWS_STARTED
         * Unit: Count
         *
         * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows module resource ID, Flows resource ID, Initiation method, Resource published timestamp
         *
         * UI name: [Flows started](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#flows-started-historical)
         *
         * ## MAX_FLOW_TIME
         * Unit: Seconds
         *
         * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows module resource ID, Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows resource ID, Initiation method, Resource published timestamp
         *
         * UI name: [Maximum flow time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#maximum-flow-time-historical)
         *
         * ## MAX_QUEUED_TIME
         * Unit: Seconds
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
         *
         * UI name: [Maximum queued time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#maximum-queued-time-historical)
         *
         * ## MIN_FLOW_TIME
         * Unit: Seconds
         *
         * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows module resource ID, Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows resource ID, Initiation method, Resource published timestamp
         *
         * UI name: [Minimum flow time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#minimum-flow-time-historical)
         *
         * ## PERCENT_CASES_FIRST_CONTACT_RESOLVED
         * Unit: Percent
         *
         * Required filter key: CASE_TEMPLATE_ARN
         *
         * Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
         *
         * UI name: [Cases resolved on first contact](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#cases-resolved-first-contact-historical)
         *
         * ## PERCENT_CONTACTS_STEP_EXPIRED
         * Unit: Percent
         *
         * Valid groupings and filters: Queue, RoutingStepExpression
         *
         * UI name: This metric is available in Real-time Metrics UI but not on the Historical Metrics UI.
         *
         * ## PERCENT_CONTACTS_STEP_JOINED
         * Unit: Percent
         *
         * Valid groupings and filters: Queue, RoutingStepExpression
         *
         * UI name: This metric is available in Real-time Metrics UI but not on the Historical Metrics UI.
         *
         * ## PERCENT_FLOWS_OUTCOME
         * Unit: Percent
         *
         * Valid metric filter key: `FLOWS_OUTCOME_TYPE`
         *
         * Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows module resource ID, Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows resource ID, Initiation method, Resource published timestamp
         *
         * UI name: [Flows outcome percentage](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#flows-outcome-percentage-historical).
         *
         * The `FLOWS_OUTCOME_TYPE` is not a valid grouping.
         *
         * ## PERCENT_NON_TALK_TIME
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         *
         * Unit: Percentage
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
         *
         * UI name: [Non-talk time percent](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#ntt-historical)
         *
         * ## PERCENT_TALK_TIME
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         *
         * Unit: Percentage
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
         *
         * UI name: [Talk time percent](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#tt-historical)
         *
         * ## PERCENT_TALK_TIME_AGENT
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         *
         * Unit: Percentage
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
         *
         * UI name: [Agent talk time percent](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#ttagent-historical)
         *
         * ## PERCENT_TALK_TIME_CUSTOMER
         * This metric is available only for contacts analyzed by Contact Lens conversational analytics.
         *
         * Unit: Percentage
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
         *
         * UI name: [Customer talk time percent](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#ttcustomer-historical)
         *
         * ## REOPENED_CASE_ACTIONS
         * Unit: Count
         *
         * Required filter key: CASE_TEMPLATE_ARN
         *
         * Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
         *
         * UI name: [Cases reopened](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#cases-reopened-historical)
         *
         * ## RESOLVED_CASE_ACTIONS
         * Unit: Count
         *
         * Required filter key: CASE_TEMPLATE_ARN
         *
         * Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
         *
         * UI name: [Cases resolved](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#cases-resolved-historical)
         *
         * ## SERVICE_LEVEL
         * You can include up to 20 SERVICE_LEVEL metrics in a request.
         *
         * Unit: Percent
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Q in Connect
         *
         * Threshold: For `ThresholdValue`, enter any whole number from 1 to 604800 (inclusive), in seconds. For `Comparison`, you must enter `LT` (for "Less than").
         *
         * UI name: [Service level X](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#service-level-historical)
         *
         * ## STEP_CONTACTS_QUEUED
         * Unit: Count
         *
         * Valid groupings and filters: Queue, RoutingStepExpression
         *
         * UI name: This metric is available in Real-time Metrics UI but not on the Historical Metrics UI.
         *
         * ## SUM_AFTER_CONTACT_WORK_TIME
         * Unit: Seconds
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         *
         * UI name: [After contact work time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#acw-historical)
         *
         * ## SUM_CONNECTING_TIME_AGENT
         * Unit: Seconds
         *
         * Valid metric filter key: `INITIATION_METHOD`. This metric only supports the following filter keys as `INITIATION_METHOD`: `INBOUND` | `OUTBOUND` | `CALLBACK` | `API`
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *
         * UI name: [Agent API connecting time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#htm-agent-api-connecting-time)
         *
         * The `Negate` key in Metric Level Filters is not applicable for this metric.
         *
         * ## SUM_CONTACTS_ABANDONED
         * Unit: Count
         *
         * Metric filter:
         * + Valid values: `API`| `Incoming` | `Outbound` | `Transfer` | `Callback` | `Queue_Transfer`| `Disconnect`
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, RoutingStepExpression, Q in Connect
         *
         * UI name: [Contact abandoned](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-abandoned-historical)
         *
         * ## SUM_CONTACTS_ABANDONED_IN_X
         * Unit: Count
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, contact/segmentAttributes/connect:Subtype, Q in Connect
         *
         * Threshold: For `ThresholdValue`, enter any whole number from 1 to 604800 (inclusive), in seconds. For `Comparison`, you must enter `LT` (for "Less than").
         *
         * UI name: [Contacts abandoned in X seconds](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-abandoned-x-historical)
         *
         * ## SUM_CONTACTS_ANSWERED_IN_X
         * Unit: Count
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, contact/segmentAttributes/connect:Subtype, Q in Connect
         *
         * Threshold: For `ThresholdValue`, enter any whole number from 1 to 604800 (inclusive), in seconds. For `Comparison`, you must enter `LT` (for "Less than").
         *
         * UI name: [Contacts answered in X seconds](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-answered-x-historical)
         *
         * ## SUM_CONTACT_FLOW_TIME
         * Unit: Seconds
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         *
         * UI name: [Contact flow time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contact-flow-time-historical)
         *
         * ## SUM_CONTACT_TIME_AGENT
         * Unit: Seconds
         *
         * Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
         *
         * UI name: [Agent on contact time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-on-contact-time-historical)
         *
         * ## SUM_CONTACTS_DISCONNECTED
         * Valid metric filter key: `DISCONNECT_REASON`
         *
         * Unit: Count
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
         *
         * UI name: [Contact disconnected](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contact-disconnected-historical)
         *
         * ## SUM_ERROR_STATUS_TIME_AGENT
         * Unit: Seconds
         *
         * Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
         *
         * UI name: [Error status time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#error-status-time-historical)
         *
         * ## SUM_HANDLE_TIME
         * Unit: Seconds
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         *
         * UI name: [Contact handle time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contact-handle-time-historical)
         *
         * ## SUM_HOLD_TIME
         * Unit: Count
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         *
         * UI name: [Customer hold time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#customer-hold-time-historical)
         *
         * ## SUM_IDLE_TIME_AGENT
         * Unit: Seconds
         *
         * Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
         *
         * UI name: [Agent idle time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-idle-time-historica)
         *
         * ## SUM_INTERACTION_AND_HOLD_TIME
         * Unit: Seconds
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect
         *
         * UI name: [Agent interaction and hold time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-interaction-hold-time-historical)
         *
         * ## SUM_INTERACTION_TIME
         * Unit: Seconds
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
         *
         * UI name: [Agent interaction time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-interaction-time-historical)
         *
         * ## SUM_NON_PRODUCTIVE_TIME_AGENT
         * Unit: Seconds
         *
         * Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
         *
         * UI name: [Non-Productive Time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#npt-historical)
         *
         * ## SUM_ONLINE_TIME_AGENT
         * Unit: Seconds
         *
         * Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
         *
         * UI name: [Online time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#online-time-historical)
         *
         * ## SUM_RETRY_CALLBACK_ATTEMPTS
         * Unit: Count
         *
         * Valid groupings and filters: Queue, Channel, Routing Profile, contact/segmentAttributes/connect:Subtype, Q in Connect
         *
         * UI name: [Callback attempts](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#callback-attempts-historical)
         */
        public var metrics: List<MetricV2>? = null
        /**
         * The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the resource. This includes the `instanceId` an Amazon Connect instance.
         */
        public var resourceArn: kotlin.String? = null
        /**
         * The timestamp, in UNIX Epoch time format, at which to start the reporting interval for the retrieval of historical metrics data. The time must be before the end time timestamp. The start and end time depends on the `IntervalPeriod` selected. By default the time range between start and end time is 35 days. Historical metrics are available for 3 months.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.GetMetricDataV2Request) : this() {
            this.endTime = x.endTime
            this.filters = x.filters
            this.groupings = x.groupings
            this.interval = x.interval
            this.maxResults = x.maxResults
            this.metrics = x.metrics
            this.nextToken = x.nextToken
            this.resourceArn = x.resourceArn
            this.startTime = x.startTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.GetMetricDataV2Request = GetMetricDataV2Request(this)

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.IntervalDetails] inside the given [block]
         */
        public fun interval(block: aws.sdk.kotlin.services.connect.model.IntervalDetails.Builder.() -> kotlin.Unit) {
            this.interval = aws.sdk.kotlin.services.connect.model.IntervalDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
