// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class GetMetricDataRequest private constructor(builder: Builder) {
    /**
     * The timestamp, in UNIX Epoch time format, at which to end the reporting interval for the retrieval of historical metrics data. The time must be specified using an interval of 5 minutes, such as 11:00, 11:05, 11:10, and must be later than the start time timestamp.
     *
     * The time range between the start and end time must be less than 24 hours.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The queues, up to 100, or channels, to use to filter the metrics returned. Metric data is retrieved only for the resources associated with the queues or channels included in the filter. You can include both queue IDs and queue ARNs in the same request. VOICE, CHAT, and TASK channels are supported.
     *
     * RoutingStepExpression is not a valid filter for GetMetricData and we recommend switching to GetMetricDataV2 for more up-to-date features.
     *
     * To filter by `Queues`, enter the queue ID/ARN, not the name of the queue.
     */
    public val filters: aws.sdk.kotlin.services.connect.model.Filters? = builder.filters
    /**
     * The grouping applied to the metrics returned. For example, when results are grouped by queue, the metrics returned are grouped by queue. The values returned apply to the metrics for each queue rather than aggregated for all queues.
     *
     * If no grouping is specified, a summary of metrics for all queues is returned.
     *
     * RoutingStepExpression is not a valid filter for GetMetricData and we recommend switching to GetMetricDataV2 for more up-to-date features.
     */
    public val groupings: List<Grouping>? = builder.groupings
    /**
     * The metrics to retrieve. Specify the name, unit, and statistic for each metric. The following historical metrics are available. For a description of each metric, see [Historical Metrics Definitions](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html) in the *Amazon Connect Administrator Guide*.
     *
     * This API does not support a contacts incoming metric (there's no CONTACTS_INCOMING metric missing from the documented list).
     *
     * ## ABANDON_TIME
     * Unit: SECONDS
     *
     * Statistic: AVG
     *
     * ## AFTER_CONTACT_WORK_TIME
     * Unit: SECONDS
     *
     * Statistic: AVG
     *
     * ## API_CONTACTS_HANDLED
     * Unit: COUNT
     *
     * Statistic: SUM
     *
     * ## CALLBACK_CONTACTS_HANDLED
     * Unit: COUNT
     *
     * Statistic: SUM
     *
     * ## CONTACTS_ABANDONED
     * Unit: COUNT
     *
     * Statistic: SUM
     *
     * ## CONTACTS_AGENT_HUNG_UP_FIRST
     * Unit: COUNT
     *
     * Statistic: SUM
     *
     * ## CONTACTS_CONSULTED
     * Unit: COUNT
     *
     * Statistic: SUM
     *
     * ## CONTACTS_HANDLED
     * Unit: COUNT
     *
     * Statistic: SUM
     *
     * ## CONTACTS_HANDLED_INCOMING
     * Unit: COUNT
     *
     * Statistic: SUM
     *
     * ## CONTACTS_HANDLED_OUTBOUND
     * Unit: COUNT
     *
     * Statistic: SUM
     *
     * ## CONTACTS_HOLD_ABANDONS
     * Unit: COUNT
     *
     * Statistic: SUM
     *
     * ## CONTACTS_MISSED
     * Unit: COUNT
     *
     * Statistic: SUM
     *
     * ## CONTACTS_QUEUED
     * Unit: COUNT
     *
     * Statistic: SUM
     *
     * ## CONTACTS_TRANSFERRED_IN
     * Unit: COUNT
     *
     * Statistic: SUM
     *
     * ## CONTACTS_TRANSFERRED_IN_FROM_QUEUE
     * Unit: COUNT
     *
     * Statistic: SUM
     *
     * ## CONTACTS_TRANSFERRED_OUT
     * Unit: COUNT
     *
     * Statistic: SUM
     *
     * ## CONTACTS_TRANSFERRED_OUT_FROM_QUEUE
     * Unit: COUNT
     *
     * Statistic: SUM
     *
     * ## HANDLE_TIME
     * Unit: SECONDS
     *
     * Statistic: AVG
     *
     * ## HOLD_TIME
     * Unit: SECONDS
     *
     * Statistic: AVG
     *
     * ## INTERACTION_AND_HOLD_TIME
     * Unit: SECONDS
     *
     * Statistic: AVG
     *
     * ## INTERACTION_TIME
     * Unit: SECONDS
     *
     * Statistic: AVG
     *
     * ## OCCUPANCY
     * Unit: PERCENT
     *
     * Statistic: AVG
     *
     * ## QUEUE_ANSWER_TIME
     * Unit: SECONDS
     *
     * Statistic: AVG
     *
     * ## QUEUED_TIME
     * Unit: SECONDS
     *
     * Statistic: MAX
     *
     * ## SERVICE_LEVEL
     * You can include up to 20 SERVICE_LEVEL metrics in a request.
     *
     * Unit: PERCENT
     *
     * Statistic: AVG
     *
     * Threshold: For `ThresholdValue`, enter any whole number from 1 to 604800 (inclusive), in seconds. For `Comparison`, you must enter `LT` (for "Less than").
     */
    public val historicalMetrics: List<HistoricalMetric>? = builder.historicalMetrics
    /**
     * The identifier of the Amazon Connect instance. You can [find the instance ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html) in the Amazon Resource Name (ARN) of the instance.
     */
    public val instanceId: kotlin.String? = builder.instanceId
    /**
     * The maximum number of results to return per page.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The timestamp, in UNIX Epoch time format, at which to start the reporting interval for the retrieval of historical metrics data. The time must be specified using a multiple of 5 minutes, such as 10:05, 10:10, 10:15.
     *
     * The start time cannot be earlier than 24 hours before the time of the request. Historical metrics are available only for 24 hours.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.GetMetricDataRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetMetricDataRequest(")
        append("endTime=$endTime,")
        append("filters=$filters,")
        append("groupings=$groupings,")
        append("historicalMetrics=$historicalMetrics,")
        append("instanceId=$instanceId,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("startTime=$startTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (groupings?.hashCode() ?: 0)
        result = 31 * result + (historicalMetrics?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetMetricDataRequest

        if (endTime != other.endTime) return false
        if (filters != other.filters) return false
        if (groupings != other.groupings) return false
        if (historicalMetrics != other.historicalMetrics) return false
        if (instanceId != other.instanceId) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (startTime != other.startTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.GetMetricDataRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The timestamp, in UNIX Epoch time format, at which to end the reporting interval for the retrieval of historical metrics data. The time must be specified using an interval of 5 minutes, such as 11:00, 11:05, 11:10, and must be later than the start time timestamp.
         *
         * The time range between the start and end time must be less than 24 hours.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The queues, up to 100, or channels, to use to filter the metrics returned. Metric data is retrieved only for the resources associated with the queues or channels included in the filter. You can include both queue IDs and queue ARNs in the same request. VOICE, CHAT, and TASK channels are supported.
         *
         * RoutingStepExpression is not a valid filter for GetMetricData and we recommend switching to GetMetricDataV2 for more up-to-date features.
         *
         * To filter by `Queues`, enter the queue ID/ARN, not the name of the queue.
         */
        public var filters: aws.sdk.kotlin.services.connect.model.Filters? = null
        /**
         * The grouping applied to the metrics returned. For example, when results are grouped by queue, the metrics returned are grouped by queue. The values returned apply to the metrics for each queue rather than aggregated for all queues.
         *
         * If no grouping is specified, a summary of metrics for all queues is returned.
         *
         * RoutingStepExpression is not a valid filter for GetMetricData and we recommend switching to GetMetricDataV2 for more up-to-date features.
         */
        public var groupings: List<Grouping>? = null
        /**
         * The metrics to retrieve. Specify the name, unit, and statistic for each metric. The following historical metrics are available. For a description of each metric, see [Historical Metrics Definitions](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html) in the *Amazon Connect Administrator Guide*.
         *
         * This API does not support a contacts incoming metric (there's no CONTACTS_INCOMING metric missing from the documented list).
         *
         * ## ABANDON_TIME
         * Unit: SECONDS
         *
         * Statistic: AVG
         *
         * ## AFTER_CONTACT_WORK_TIME
         * Unit: SECONDS
         *
         * Statistic: AVG
         *
         * ## API_CONTACTS_HANDLED
         * Unit: COUNT
         *
         * Statistic: SUM
         *
         * ## CALLBACK_CONTACTS_HANDLED
         * Unit: COUNT
         *
         * Statistic: SUM
         *
         * ## CONTACTS_ABANDONED
         * Unit: COUNT
         *
         * Statistic: SUM
         *
         * ## CONTACTS_AGENT_HUNG_UP_FIRST
         * Unit: COUNT
         *
         * Statistic: SUM
         *
         * ## CONTACTS_CONSULTED
         * Unit: COUNT
         *
         * Statistic: SUM
         *
         * ## CONTACTS_HANDLED
         * Unit: COUNT
         *
         * Statistic: SUM
         *
         * ## CONTACTS_HANDLED_INCOMING
         * Unit: COUNT
         *
         * Statistic: SUM
         *
         * ## CONTACTS_HANDLED_OUTBOUND
         * Unit: COUNT
         *
         * Statistic: SUM
         *
         * ## CONTACTS_HOLD_ABANDONS
         * Unit: COUNT
         *
         * Statistic: SUM
         *
         * ## CONTACTS_MISSED
         * Unit: COUNT
         *
         * Statistic: SUM
         *
         * ## CONTACTS_QUEUED
         * Unit: COUNT
         *
         * Statistic: SUM
         *
         * ## CONTACTS_TRANSFERRED_IN
         * Unit: COUNT
         *
         * Statistic: SUM
         *
         * ## CONTACTS_TRANSFERRED_IN_FROM_QUEUE
         * Unit: COUNT
         *
         * Statistic: SUM
         *
         * ## CONTACTS_TRANSFERRED_OUT
         * Unit: COUNT
         *
         * Statistic: SUM
         *
         * ## CONTACTS_TRANSFERRED_OUT_FROM_QUEUE
         * Unit: COUNT
         *
         * Statistic: SUM
         *
         * ## HANDLE_TIME
         * Unit: SECONDS
         *
         * Statistic: AVG
         *
         * ## HOLD_TIME
         * Unit: SECONDS
         *
         * Statistic: AVG
         *
         * ## INTERACTION_AND_HOLD_TIME
         * Unit: SECONDS
         *
         * Statistic: AVG
         *
         * ## INTERACTION_TIME
         * Unit: SECONDS
         *
         * Statistic: AVG
         *
         * ## OCCUPANCY
         * Unit: PERCENT
         *
         * Statistic: AVG
         *
         * ## QUEUE_ANSWER_TIME
         * Unit: SECONDS
         *
         * Statistic: AVG
         *
         * ## QUEUED_TIME
         * Unit: SECONDS
         *
         * Statistic: MAX
         *
         * ## SERVICE_LEVEL
         * You can include up to 20 SERVICE_LEVEL metrics in a request.
         *
         * Unit: PERCENT
         *
         * Statistic: AVG
         *
         * Threshold: For `ThresholdValue`, enter any whole number from 1 to 604800 (inclusive), in seconds. For `Comparison`, you must enter `LT` (for "Less than").
         */
        public var historicalMetrics: List<HistoricalMetric>? = null
        /**
         * The identifier of the Amazon Connect instance. You can [find the instance ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html) in the Amazon Resource Name (ARN) of the instance.
         */
        public var instanceId: kotlin.String? = null
        /**
         * The maximum number of results to return per page.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The timestamp, in UNIX Epoch time format, at which to start the reporting interval for the retrieval of historical metrics data. The time must be specified using a multiple of 5 minutes, such as 10:05, 10:10, 10:15.
         *
         * The start time cannot be earlier than 24 hours before the time of the request. Historical metrics are available only for 24 hours.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.GetMetricDataRequest) : this() {
            this.endTime = x.endTime
            this.filters = x.filters
            this.groupings = x.groupings
            this.historicalMetrics = x.historicalMetrics
            this.instanceId = x.instanceId
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.startTime = x.startTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.GetMetricDataRequest = GetMetricDataRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.Filters] inside the given [block]
         */
        public fun filters(block: aws.sdk.kotlin.services.connect.model.Filters.Builder.() -> kotlin.Unit) {
            this.filters = aws.sdk.kotlin.services.connect.model.Filters.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
