// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains information about a default vocabulary.
 */
public class DefaultVocabulary private constructor(builder: Builder) {
    /**
     * The identifier of the Amazon Connect instance. You can [find the instance ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html) in the Amazon Resource Name (ARN) of the instance.
     */
    public val instanceId: kotlin.String = requireNotNull(builder.instanceId) { "A non-null value must be provided for instanceId" }
    /**
     * The language code of the vocabulary entries. For a list of languages and their corresponding language codes, see [What is Amazon Transcribe?](https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-whatis.html)
     */
    public val languageCode: aws.sdk.kotlin.services.connect.model.VocabularyLanguageCode = requireNotNull(builder.languageCode) { "A non-null value must be provided for languageCode" }
    /**
     * The identifier of the custom vocabulary.
     */
    public val vocabularyId: kotlin.String = requireNotNull(builder.vocabularyId) { "A non-null value must be provided for vocabularyId" }
    /**
     * A unique name of the custom vocabulary.
     */
    public val vocabularyName: kotlin.String = requireNotNull(builder.vocabularyName) { "A non-null value must be provided for vocabularyName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.DefaultVocabulary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DefaultVocabulary(")
        append("instanceId=$instanceId,")
        append("languageCode=$languageCode,")
        append("vocabularyId=$vocabularyId,")
        append("vocabularyName=$vocabularyName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = instanceId.hashCode()
        result = 31 * result + (languageCode.hashCode())
        result = 31 * result + (vocabularyId.hashCode())
        result = 31 * result + (vocabularyName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DefaultVocabulary

        if (instanceId != other.instanceId) return false
        if (languageCode != other.languageCode) return false
        if (vocabularyId != other.vocabularyId) return false
        if (vocabularyName != other.vocabularyName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.DefaultVocabulary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier of the Amazon Connect instance. You can [find the instance ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html) in the Amazon Resource Name (ARN) of the instance.
         */
        public var instanceId: kotlin.String? = null
        /**
         * The language code of the vocabulary entries. For a list of languages and their corresponding language codes, see [What is Amazon Transcribe?](https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-whatis.html)
         */
        public var languageCode: aws.sdk.kotlin.services.connect.model.VocabularyLanguageCode? = null
        /**
         * The identifier of the custom vocabulary.
         */
        public var vocabularyId: kotlin.String? = null
        /**
         * A unique name of the custom vocabulary.
         */
        public var vocabularyName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.DefaultVocabulary) : this() {
            this.instanceId = x.instanceId
            this.languageCode = x.languageCode
            this.vocabularyId = x.vocabularyId
            this.vocabularyName = x.vocabularyName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.DefaultVocabulary = DefaultVocabulary(this)

        internal fun correctErrors(): Builder {
            if (instanceId == null) instanceId = ""
            if (languageCode == null) languageCode = VocabularyLanguageCode.SdkUnknown("no value provided")
            if (vocabularyId == null) vocabularyId = ""
            if (vocabularyName == null) vocabularyName = ""
            return this
        }
    }
}
