// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateSecurityProfileRequest private constructor(builder: Builder) {
    /**
     * The identifier of the hierarchy group that a security profile uses to restrict access to resources in Amazon Connect.
     */
    public val allowedAccessControlHierarchyGroupId: kotlin.String? = builder.allowedAccessControlHierarchyGroupId
    /**
     * The list of tags that a security profile uses to restrict access to resources in Amazon Connect.
     */
    public val allowedAccessControlTags: Map<String, String>? = builder.allowedAccessControlTags
    /**
     * A list of third-party applications that the security profile will give access to.
     */
    public val applications: List<Application>? = builder.applications
    /**
     * The description of the security profile.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The list of resources that a security profile applies hierarchy restrictions to in Amazon Connect. Following are acceptable ResourceNames: `User`.
     */
    public val hierarchyRestrictedResources: List<String>? = builder.hierarchyRestrictedResources
    /**
     * The identifier of the Amazon Connect instance. You can [find the instance ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html) in the Amazon Resource Name (ARN) of the instance.
     */
    public val instanceId: kotlin.String? = builder.instanceId
    /**
     * Permissions assigned to the security profile. For a list of valid permissions, see [List of security profile permissions](https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-list.html).
     */
    public val permissions: List<String>? = builder.permissions
    /**
     * The name of the security profile.
     */
    public val securityProfileName: kotlin.String? = builder.securityProfileName
    /**
     * The list of resources that a security profile applies tag restrictions to in Amazon Connect. Following are acceptable ResourceNames: `User` | `SecurityProfile` | `Queue` | `RoutingProfile`
     */
    public val tagRestrictedResources: List<String>? = builder.tagRestrictedResources
    /**
     * The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.CreateSecurityProfileRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateSecurityProfileRequest(")
        append("allowedAccessControlHierarchyGroupId=$allowedAccessControlHierarchyGroupId,")
        append("allowedAccessControlTags=$allowedAccessControlTags,")
        append("applications=$applications,")
        append("description=$description,")
        append("hierarchyRestrictedResources=$hierarchyRestrictedResources,")
        append("instanceId=$instanceId,")
        append("permissions=$permissions,")
        append("securityProfileName=$securityProfileName,")
        append("tagRestrictedResources=$tagRestrictedResources,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowedAccessControlHierarchyGroupId?.hashCode() ?: 0
        result = 31 * result + (allowedAccessControlTags?.hashCode() ?: 0)
        result = 31 * result + (applications?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (hierarchyRestrictedResources?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (permissions?.hashCode() ?: 0)
        result = 31 * result + (securityProfileName?.hashCode() ?: 0)
        result = 31 * result + (tagRestrictedResources?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateSecurityProfileRequest

        if (allowedAccessControlHierarchyGroupId != other.allowedAccessControlHierarchyGroupId) return false
        if (allowedAccessControlTags != other.allowedAccessControlTags) return false
        if (applications != other.applications) return false
        if (description != other.description) return false
        if (hierarchyRestrictedResources != other.hierarchyRestrictedResources) return false
        if (instanceId != other.instanceId) return false
        if (permissions != other.permissions) return false
        if (securityProfileName != other.securityProfileName) return false
        if (tagRestrictedResources != other.tagRestrictedResources) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.CreateSecurityProfileRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier of the hierarchy group that a security profile uses to restrict access to resources in Amazon Connect.
         */
        public var allowedAccessControlHierarchyGroupId: kotlin.String? = null
        /**
         * The list of tags that a security profile uses to restrict access to resources in Amazon Connect.
         */
        public var allowedAccessControlTags: Map<String, String>? = null
        /**
         * A list of third-party applications that the security profile will give access to.
         */
        public var applications: List<Application>? = null
        /**
         * The description of the security profile.
         */
        public var description: kotlin.String? = null
        /**
         * The list of resources that a security profile applies hierarchy restrictions to in Amazon Connect. Following are acceptable ResourceNames: `User`.
         */
        public var hierarchyRestrictedResources: List<String>? = null
        /**
         * The identifier of the Amazon Connect instance. You can [find the instance ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html) in the Amazon Resource Name (ARN) of the instance.
         */
        public var instanceId: kotlin.String? = null
        /**
         * Permissions assigned to the security profile. For a list of valid permissions, see [List of security profile permissions](https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-list.html).
         */
        public var permissions: List<String>? = null
        /**
         * The name of the security profile.
         */
        public var securityProfileName: kotlin.String? = null
        /**
         * The list of resources that a security profile applies tag restrictions to in Amazon Connect. Following are acceptable ResourceNames: `User` | `SecurityProfile` | `Queue` | `RoutingProfile`
         */
        public var tagRestrictedResources: List<String>? = null
        /**
         * The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.CreateSecurityProfileRequest) : this() {
            this.allowedAccessControlHierarchyGroupId = x.allowedAccessControlHierarchyGroupId
            this.allowedAccessControlTags = x.allowedAccessControlTags
            this.applications = x.applications
            this.description = x.description
            this.hierarchyRestrictedResources = x.hierarchyRestrictedResources
            this.instanceId = x.instanceId
            this.permissions = x.permissions
            this.securityProfileName = x.securityProfileName
            this.tagRestrictedResources = x.tagRestrictedResources
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.CreateSecurityProfileRequest = CreateSecurityProfileRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
