// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateIntegrationAssociationRequest private constructor(builder: Builder) {
    /**
     * The identifier of the Amazon Connect instance. You can [find the instance ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html) in the Amazon Resource Name (ARN) of the instance.
     */
    public val instanceId: kotlin.String? = builder.instanceId
    /**
     * The Amazon Resource Name (ARN) of the integration.
     *
     * When integrating with Amazon Pinpoint, the Amazon Connect and Amazon Pinpoint instances must be in the same account.
     */
    public val integrationArn: kotlin.String? = builder.integrationArn
    /**
     * The type of information to be ingested.
     */
    public val integrationType: aws.sdk.kotlin.services.connect.model.IntegrationType? = builder.integrationType
    /**
     * The name of the external application. This field is only required for the EVENT integration type.
     */
    public val sourceApplicationName: kotlin.String? = builder.sourceApplicationName
    /**
     * The URL for the external application. This field is only required for the EVENT integration type.
     */
    public val sourceApplicationUrl: kotlin.String? = builder.sourceApplicationUrl
    /**
     * The type of the data source. This field is only required for the EVENT integration type.
     */
    public val sourceType: aws.sdk.kotlin.services.connect.model.SourceType? = builder.sourceType
    /**
     * The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.CreateIntegrationAssociationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateIntegrationAssociationRequest(")
        append("instanceId=$instanceId,")
        append("integrationArn=$integrationArn,")
        append("integrationType=$integrationType,")
        append("sourceApplicationName=$sourceApplicationName,")
        append("sourceApplicationUrl=$sourceApplicationUrl,")
        append("sourceType=$sourceType,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = instanceId?.hashCode() ?: 0
        result = 31 * result + (integrationArn?.hashCode() ?: 0)
        result = 31 * result + (integrationType?.hashCode() ?: 0)
        result = 31 * result + (sourceApplicationName?.hashCode() ?: 0)
        result = 31 * result + (sourceApplicationUrl?.hashCode() ?: 0)
        result = 31 * result + (sourceType?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateIntegrationAssociationRequest

        if (instanceId != other.instanceId) return false
        if (integrationArn != other.integrationArn) return false
        if (integrationType != other.integrationType) return false
        if (sourceApplicationName != other.sourceApplicationName) return false
        if (sourceApplicationUrl != other.sourceApplicationUrl) return false
        if (sourceType != other.sourceType) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.CreateIntegrationAssociationRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier of the Amazon Connect instance. You can [find the instance ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html) in the Amazon Resource Name (ARN) of the instance.
         */
        public var instanceId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the integration.
         *
         * When integrating with Amazon Pinpoint, the Amazon Connect and Amazon Pinpoint instances must be in the same account.
         */
        public var integrationArn: kotlin.String? = null
        /**
         * The type of information to be ingested.
         */
        public var integrationType: aws.sdk.kotlin.services.connect.model.IntegrationType? = null
        /**
         * The name of the external application. This field is only required for the EVENT integration type.
         */
        public var sourceApplicationName: kotlin.String? = null
        /**
         * The URL for the external application. This field is only required for the EVENT integration type.
         */
        public var sourceApplicationUrl: kotlin.String? = null
        /**
         * The type of the data source. This field is only required for the EVENT integration type.
         */
        public var sourceType: aws.sdk.kotlin.services.connect.model.SourceType? = null
        /**
         * The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.CreateIntegrationAssociationRequest) : this() {
            this.instanceId = x.instanceId
            this.integrationArn = x.integrationArn
            this.integrationType = x.integrationType
            this.sourceApplicationName = x.sourceApplicationName
            this.sourceApplicationUrl = x.sourceApplicationUrl
            this.sourceType = x.sourceType
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.CreateIntegrationAssociationRequest = CreateIntegrationAssociationRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
