// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateContactFlowRequest private constructor(builder: Builder) {
    /**
     * The JSON string that represents the content of the flow. For an example, see [Example flow in Amazon Connect Flow language](https://docs.aws.amazon.com/connect/latest/APIReference/flow-language-example.html).
     *
     * Length Constraints: Minimum length of 1. Maximum length of 256000.
     */
    public val content: kotlin.String? = builder.content
    /**
     * The description of the flow.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The identifier of the Amazon Connect instance.
     */
    public val instanceId: kotlin.String? = builder.instanceId
    /**
     * The name of the flow.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Indicates the flow status as either `SAVED` or `PUBLISHED`. The `PUBLISHED` status will initiate validation on the content. the `SAVED` status does not initiate validation of the content. `SAVED` | `PUBLISHED`.
     */
    public val status: aws.sdk.kotlin.services.connect.model.ContactFlowStatus? = builder.status
    /**
     * The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The type of the flow. For descriptions of the available types, see [Choose a flow type](https://docs.aws.amazon.com/connect/latest/adminguide/create-contact-flow.html#contact-flow-types) in the *Amazon Connect Administrator Guide*.
     */
    public val type: aws.sdk.kotlin.services.connect.model.ContactFlowType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.CreateContactFlowRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateContactFlowRequest(")
        append("content=$content,")
        append("description=$description,")
        append("instanceId=$instanceId,")
        append("name=$name,")
        append("status=$status,")
        append("tags=$tags,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = content?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateContactFlowRequest

        if (content != other.content) return false
        if (description != other.description) return false
        if (instanceId != other.instanceId) return false
        if (name != other.name) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.CreateContactFlowRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The JSON string that represents the content of the flow. For an example, see [Example flow in Amazon Connect Flow language](https://docs.aws.amazon.com/connect/latest/APIReference/flow-language-example.html).
         *
         * Length Constraints: Minimum length of 1. Maximum length of 256000.
         */
        public var content: kotlin.String? = null
        /**
         * The description of the flow.
         */
        public var description: kotlin.String? = null
        /**
         * The identifier of the Amazon Connect instance.
         */
        public var instanceId: kotlin.String? = null
        /**
         * The name of the flow.
         */
        public var name: kotlin.String? = null
        /**
         * Indicates the flow status as either `SAVED` or `PUBLISHED`. The `PUBLISHED` status will initiate validation on the content. the `SAVED` status does not initiate validation of the content. `SAVED` | `PUBLISHED`.
         */
        public var status: aws.sdk.kotlin.services.connect.model.ContactFlowStatus? = null
        /**
         * The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.
         */
        public var tags: Map<String, String>? = null
        /**
         * The type of the flow. For descriptions of the available types, see [Choose a flow type](https://docs.aws.amazon.com/connect/latest/adminguide/create-contact-flow.html#contact-flow-types) in the *Amazon Connect Administrator Guide*.
         */
        public var type: aws.sdk.kotlin.services.connect.model.ContactFlowType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.CreateContactFlowRequest) : this() {
            this.content = x.content
            this.description = x.description
            this.instanceId = x.instanceId
            this.name = x.name
            this.status = x.status
            this.tags = x.tags
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.CreateContactFlowRequest = CreateContactFlowRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
