// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An object that can be used to specify Tag conditions or Hierarchy Group conditions inside the `SearchFilter`.
 *
 * This accepts an `OR` of `AND` (List of List) input where:
 * + The top level list specifies conditions that need to be applied with `OR` operator
 * + The inner list specifies conditions that need to be applied with `AND` operator.
 *
 * Only one field can be populated. Maximum number of allowed Tag conditions is 25. Maximum number of allowed Hierarchy Group conditions is 20.
 */
public class ControlPlaneUserAttributeFilter private constructor(builder: Builder) {
    /**
     * A list of conditions which would be applied together with an `AND` condition.
     */
    public val andCondition: aws.sdk.kotlin.services.connect.model.AttributeAndCondition? = builder.andCondition
    /**
     * A leaf node condition which can be used to specify a hierarchy group condition.
     */
    public val hierarchyGroupCondition: aws.sdk.kotlin.services.connect.model.HierarchyGroupCondition? = builder.hierarchyGroupCondition
    /**
     * A list of conditions which would be applied together with an `OR` condition.
     */
    public val orConditions: List<AttributeAndCondition>? = builder.orConditions
    /**
     * A leaf node condition which can be used to specify a tag condition, for example, `HAVE BPO = 123`.
     */
    public val tagCondition: aws.sdk.kotlin.services.connect.model.TagCondition? = builder.tagCondition

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.ControlPlaneUserAttributeFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ControlPlaneUserAttributeFilter(")
        append("andCondition=$andCondition,")
        append("hierarchyGroupCondition=$hierarchyGroupCondition,")
        append("orConditions=$orConditions,")
        append("tagCondition=$tagCondition")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = andCondition?.hashCode() ?: 0
        result = 31 * result + (hierarchyGroupCondition?.hashCode() ?: 0)
        result = 31 * result + (orConditions?.hashCode() ?: 0)
        result = 31 * result + (tagCondition?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ControlPlaneUserAttributeFilter

        if (andCondition != other.andCondition) return false
        if (hierarchyGroupCondition != other.hierarchyGroupCondition) return false
        if (orConditions != other.orConditions) return false
        if (tagCondition != other.tagCondition) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.ControlPlaneUserAttributeFilter = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list of conditions which would be applied together with an `AND` condition.
         */
        public var andCondition: aws.sdk.kotlin.services.connect.model.AttributeAndCondition? = null
        /**
         * A leaf node condition which can be used to specify a hierarchy group condition.
         */
        public var hierarchyGroupCondition: aws.sdk.kotlin.services.connect.model.HierarchyGroupCondition? = null
        /**
         * A list of conditions which would be applied together with an `OR` condition.
         */
        public var orConditions: List<AttributeAndCondition>? = null
        /**
         * A leaf node condition which can be used to specify a tag condition, for example, `HAVE BPO = 123`.
         */
        public var tagCondition: aws.sdk.kotlin.services.connect.model.TagCondition? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.ControlPlaneUserAttributeFilter) : this() {
            this.andCondition = x.andCondition
            this.hierarchyGroupCondition = x.hierarchyGroupCondition
            this.orConditions = x.orConditions
            this.tagCondition = x.tagCondition
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.ControlPlaneUserAttributeFilter = ControlPlaneUserAttributeFilter(this)

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.AttributeAndCondition] inside the given [block]
         */
        public fun andCondition(block: aws.sdk.kotlin.services.connect.model.AttributeAndCondition.Builder.() -> kotlin.Unit) {
            this.andCondition = aws.sdk.kotlin.services.connect.model.AttributeAndCondition.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.HierarchyGroupCondition] inside the given [block]
         */
        public fun hierarchyGroupCondition(block: aws.sdk.kotlin.services.connect.model.HierarchyGroupCondition.Builder.() -> kotlin.Unit) {
            this.hierarchyGroupCondition = aws.sdk.kotlin.services.connect.model.HierarchyGroupCondition.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.TagCondition] inside the given [block]
         */
        public fun tagCondition(block: aws.sdk.kotlin.services.connect.model.TagCondition.Builder.() -> kotlin.Unit) {
            this.tagCondition = aws.sdk.kotlin.services.connect.model.TagCondition.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
