// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about the attached file.
 */
public class AttachedFile private constructor(builder: Builder) {
    /**
     * The resource to which the attached file is (being) uploaded to. [Cases](https://docs.aws.amazon.com/connect/latest/APIReference/API_connect-cases_CreateCase.html) are the only current supported resource.
     *
     * This value must be a valid ARN.
     */
    public val associatedResourceArn: kotlin.String? = builder.associatedResourceArn
    /**
     * Represents the identity that created the file.
     */
    public val createdBy: aws.sdk.kotlin.services.connect.model.CreatedByInfo? = builder.createdBy
    /**
     * The time of Creation of the file resource as an ISO timestamp. It's specified in ISO 8601 format: `yyyy-MM-ddThh:mm:ss.SSSZ`. For example, `2024-05-03T02:41:28.172Z`.
     */
    public val creationTime: kotlin.String = requireNotNull(builder.creationTime) { "A non-null value must be provided for creationTime" }
    /**
     * The unique identifier of the attached file resource (ARN).
     */
    public val fileArn: kotlin.String = requireNotNull(builder.fileArn) { "A non-null value must be provided for fileArn" }
    /**
     * The unique identifier of the attached file resource.
     */
    public val fileId: kotlin.String = requireNotNull(builder.fileId) { "A non-null value must be provided for fileId" }
    /**
     * A case-sensitive name of the attached file being uploaded.
     */
    public val fileName: kotlin.String = requireNotNull(builder.fileName) { "A non-null value must be provided for fileName" }
    /**
     * The size of the attached file in bytes.
     */
    public val fileSizeInBytes: kotlin.Long = requireNotNull(builder.fileSizeInBytes) { "A non-null value must be provided for fileSizeInBytes" }
    /**
     * The current status of the attached file.
     */
    public val fileStatus: aws.sdk.kotlin.services.connect.model.FileStatusType = requireNotNull(builder.fileStatus) { "A non-null value must be provided for fileStatus" }
    /**
     * The use case for the file.
     */
    public val fileUseCaseType: aws.sdk.kotlin.services.connect.model.FileUseCaseType? = builder.fileUseCaseType
    /**
     * The tags used to organize, track, or control access for this resource. For example, `{ "Tags": {"key1":"value1", "key2":"value2"} }`.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.AttachedFile = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AttachedFile(")
        append("associatedResourceArn=$associatedResourceArn,")
        append("createdBy=$createdBy,")
        append("creationTime=$creationTime,")
        append("fileArn=$fileArn,")
        append("fileId=$fileId,")
        append("fileName=$fileName,")
        append("fileSizeInBytes=$fileSizeInBytes,")
        append("fileStatus=$fileStatus,")
        append("fileUseCaseType=$fileUseCaseType,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = associatedResourceArn?.hashCode() ?: 0
        result = 31 * result + (createdBy?.hashCode() ?: 0)
        result = 31 * result + (creationTime.hashCode())
        result = 31 * result + (fileArn.hashCode())
        result = 31 * result + (fileId.hashCode())
        result = 31 * result + (fileName.hashCode())
        result = 31 * result + (fileSizeInBytes.hashCode())
        result = 31 * result + (fileStatus.hashCode())
        result = 31 * result + (fileUseCaseType?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AttachedFile

        if (associatedResourceArn != other.associatedResourceArn) return false
        if (createdBy != other.createdBy) return false
        if (creationTime != other.creationTime) return false
        if (fileArn != other.fileArn) return false
        if (fileId != other.fileId) return false
        if (fileName != other.fileName) return false
        if (fileSizeInBytes != other.fileSizeInBytes) return false
        if (fileStatus != other.fileStatus) return false
        if (fileUseCaseType != other.fileUseCaseType) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.AttachedFile = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The resource to which the attached file is (being) uploaded to. [Cases](https://docs.aws.amazon.com/connect/latest/APIReference/API_connect-cases_CreateCase.html) are the only current supported resource.
         *
         * This value must be a valid ARN.
         */
        public var associatedResourceArn: kotlin.String? = null
        /**
         * Represents the identity that created the file.
         */
        public var createdBy: aws.sdk.kotlin.services.connect.model.CreatedByInfo? = null
        /**
         * The time of Creation of the file resource as an ISO timestamp. It's specified in ISO 8601 format: `yyyy-MM-ddThh:mm:ss.SSSZ`. For example, `2024-05-03T02:41:28.172Z`.
         */
        public var creationTime: kotlin.String? = null
        /**
         * The unique identifier of the attached file resource (ARN).
         */
        public var fileArn: kotlin.String? = null
        /**
         * The unique identifier of the attached file resource.
         */
        public var fileId: kotlin.String? = null
        /**
         * A case-sensitive name of the attached file being uploaded.
         */
        public var fileName: kotlin.String? = null
        /**
         * The size of the attached file in bytes.
         */
        public var fileSizeInBytes: kotlin.Long? = null
        /**
         * The current status of the attached file.
         */
        public var fileStatus: aws.sdk.kotlin.services.connect.model.FileStatusType? = null
        /**
         * The use case for the file.
         */
        public var fileUseCaseType: aws.sdk.kotlin.services.connect.model.FileUseCaseType? = null
        /**
         * The tags used to organize, track, or control access for this resource. For example, `{ "Tags": {"key1":"value1", "key2":"value2"} }`.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.AttachedFile) : this() {
            this.associatedResourceArn = x.associatedResourceArn
            this.createdBy = x.createdBy
            this.creationTime = x.creationTime
            this.fileArn = x.fileArn
            this.fileId = x.fileId
            this.fileName = x.fileName
            this.fileSizeInBytes = x.fileSizeInBytes
            this.fileStatus = x.fileStatus
            this.fileUseCaseType = x.fileUseCaseType
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.AttachedFile = AttachedFile(this)

        internal fun correctErrors(): Builder {
            if (creationTime == null) creationTime = ""
            if (fileArn == null) fileArn = ""
            if (fileId == null) fileId = ""
            if (fileName == null) fileName = ""
            if (fileSizeInBytes == null) fileSizeInBytes = 0L
            if (fileStatus == null) fileStatus = FileStatusType.SdkUnknown("no value provided")
            return this
        }
    }
}
