// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.serde

import aws.sdk.kotlin.services.connect.model.RuleAction
import aws.sdk.kotlin.services.connect.model.RulePublishStatus
import aws.sdk.kotlin.services.connect.model.UpdateRuleRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateRuleOperationSerializer: HttpSerializer.NonStreaming<UpdateRuleRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateRuleRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.instanceId) { "instanceId is bound to the URI and must not be null" }
            requireNotNull(input.ruleId) { "ruleId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("rules"))
                add(PercentEncoding.SmithyLabel.encode("${input.instanceId}"))
                add(PercentEncoding.SmithyLabel.encode("${input.ruleId}"))
            }
        }

        val payload = serializeUpdateRuleOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateRuleOperationBody(context: ExecutionContext, input: UpdateRuleRequest): ByteArray {
    val serializer = JsonSerializer()
    val ACTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Actions"))
    val FUNCTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Function"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val PUBLISHSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("PublishStatus"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACTIONS_DESCRIPTOR)
        field(FUNCTION_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(PUBLISHSTATUS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.actions != null) {
            listField(ACTIONS_DESCRIPTOR) {
                for (el0 in input.actions) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeRuleActionDocument))
                }
            }
        }
        input.function?.let { field(FUNCTION_DESCRIPTOR, it) }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        input.publishStatus?.let { field(PUBLISHSTATUS_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
