// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.serde

import aws.sdk.kotlin.services.connect.model.AllowedCapabilities
import aws.sdk.kotlin.services.connect.model.ParticipantDetails
import aws.sdk.kotlin.services.connect.model.Reference
import aws.sdk.kotlin.services.connect.model.StartWebRtcContactRequest
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class StartWebRTCContactOperationSerializer: HttpSerializer.NonStreaming<StartWebRtcContactRequest> {
    override fun serialize(context: ExecutionContext, input: StartWebRtcContactRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            path.encoded = "/contact/webrtc"
        }

        val payload = serializeStartWebRTCContactOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeStartWebRTCContactOperationBody(context: ExecutionContext, input: StartWebRtcContactRequest): ByteArray {
    val serializer = JsonSerializer()
    val ALLOWEDCAPABILITIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AllowedCapabilities"))
    val ATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Attributes"))
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ClientToken"))
    val CONTACTFLOWID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ContactFlowId"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val INSTANCEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("InstanceId"))
    val PARTICIPANTDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ParticipantDetails"))
    val REFERENCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("References"))
    val RELATEDCONTACTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RelatedContactId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ALLOWEDCAPABILITIES_DESCRIPTOR)
        field(ATTRIBUTES_DESCRIPTOR)
        field(CLIENTTOKEN_DESCRIPTOR)
        field(CONTACTFLOWID_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(INSTANCEID_DESCRIPTOR)
        field(PARTICIPANTDETAILS_DESCRIPTOR)
        field(REFERENCES_DESCRIPTOR)
        field(RELATEDCONTACTID_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.allowedCapabilities?.let { field(ALLOWEDCAPABILITIES_DESCRIPTOR, it, ::serializeAllowedCapabilitiesDocument) }
        if (input.attributes != null) {
            mapField(ATTRIBUTES_DESCRIPTOR) {
                input.attributes.forEach { (key, value) -> entry(key, value) }
            }
        }
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.contactFlowId?.let { field(CONTACTFLOWID_DESCRIPTOR, it) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.instanceId?.let { field(INSTANCEID_DESCRIPTOR, it) }
        input.participantDetails?.let { field(PARTICIPANTDETAILS_DESCRIPTOR, it, ::serializeParticipantDetailsDocument) }
        if (input.references != null) {
            mapField(REFERENCES_DESCRIPTOR) {
                input.references.forEach { (key, value) -> entry(key, asSdkSerializable(value, ::serializeReferenceDocument)) }
            }
        }
        input.relatedContactId?.let { field(RELATEDCONTACTID_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
