// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.serde

import aws.sdk.kotlin.services.connect.model.ConnectException
import aws.sdk.kotlin.services.connect.model.CreatedByInfo
import aws.sdk.kotlin.services.connect.model.DownloadUrlMetadata
import aws.sdk.kotlin.services.connect.model.FileStatusType
import aws.sdk.kotlin.services.connect.model.FileUseCaseType
import aws.sdk.kotlin.services.connect.model.GetAttachedFileResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableMapOf


internal class GetAttachedFileOperationDeserializer: HttpDeserializer.NonStreaming<GetAttachedFileResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetAttachedFileResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetAttachedFileError(context, call, payload)
        }
        val builder = GetAttachedFileResponse.Builder()

        if (payload != null) {
            deserializeGetAttachedFileOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetAttachedFileError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ConnectException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServiceException" -> InternalServiceExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ConnectException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetAttachedFileOperationBody(builder: GetAttachedFileResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ASSOCIATEDRESOURCEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AssociatedResourceArn"))
    val CREATEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("CreatedBy"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CreationTime"))
    val DOWNLOADURLMETADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DownloadUrlMetadata"))
    val FILEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FileArn"))
    val FILEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FileId"))
    val FILENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FileName"))
    val FILESIZEINBYTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("FileSizeInBytes"))
    val FILESTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("FileStatus"))
    val FILEUSECASETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("FileUseCaseType"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ASSOCIATEDRESOURCEARN_DESCRIPTOR)
        field(CREATEDBY_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(DOWNLOADURLMETADATA_DESCRIPTOR)
        field(FILEARN_DESCRIPTOR)
        field(FILEID_DESCRIPTOR)
        field(FILENAME_DESCRIPTOR)
        field(FILESIZEINBYTES_DESCRIPTOR)
        field(FILESTATUS_DESCRIPTOR)
        field(FILEUSECASETYPE_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ASSOCIATEDRESOURCEARN_DESCRIPTOR.index -> builder.associatedResourceArn = deserializeString()
                CREATEDBY_DESCRIPTOR.index -> builder.createdBy = deserializeCreatedByInfoDocument(deserializer)
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString()
                DOWNLOADURLMETADATA_DESCRIPTOR.index -> builder.downloadUrlMetadata = deserializeDownloadUrlMetadataDocument(deserializer)
                FILEARN_DESCRIPTOR.index -> builder.fileArn = deserializeString()
                FILEID_DESCRIPTOR.index -> builder.fileId = deserializeString()
                FILENAME_DESCRIPTOR.index -> builder.fileName = deserializeString()
                FILESIZEINBYTES_DESCRIPTOR.index -> builder.fileSizeInBytes = deserializeLong()
                FILESTATUS_DESCRIPTOR.index -> builder.fileStatus = deserializeString().let { FileStatusType.fromValue(it) }
                FILEUSECASETYPE_DESCRIPTOR.index -> builder.fileUseCaseType = deserializeString().let { FileUseCaseType.fromValue(it) }
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
