// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about a custom vocabulary.
 */
public class Vocabulary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the custom vocabulary.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * The content of the custom vocabulary in plain-text format with a table of values. Each row in the table represents a word or a phrase, described with `Phrase`, `IPA`, `SoundsLike`, and `DisplayAs` fields. Separate the fields with TAB characters. For more information, see [Create a custom vocabulary using a table](https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html#create-vocabulary-table).
     */
    public val content: kotlin.String? = builder.content
    /**
     * The reason why the custom vocabulary was not created.
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * The identifier of the custom vocabulary.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The language code of the vocabulary entries. For a list of languages and their corresponding language codes, see [What is Amazon Transcribe?](https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-whatis.html)
     */
    public val languageCode: aws.sdk.kotlin.services.connect.model.VocabularyLanguageCode = requireNotNull(builder.languageCode) { "A non-null value must be provided for languageCode" }
    /**
     * The timestamp when the custom vocabulary was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastModifiedTime) { "A non-null value must be provided for lastModifiedTime" }
    /**
     * A unique name of the custom vocabulary.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The current state of the custom vocabulary.
     */
    public val state: aws.sdk.kotlin.services.connect.model.VocabularyState = requireNotNull(builder.state) { "A non-null value must be provided for state" }
    /**
     * The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.Vocabulary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Vocabulary(")
        append("arn=$arn,")
        append("content=$content,")
        append("failureReason=$failureReason,")
        append("id=$id,")
        append("languageCode=$languageCode,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("name=$name,")
        append("state=$state,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (content?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (id.hashCode())
        result = 31 * result + (languageCode.hashCode())
        result = 31 * result + (lastModifiedTime.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (state.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Vocabulary

        if (arn != other.arn) return false
        if (content != other.content) return false
        if (failureReason != other.failureReason) return false
        if (id != other.id) return false
        if (languageCode != other.languageCode) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (name != other.name) return false
        if (state != other.state) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.Vocabulary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the custom vocabulary.
         */
        public var arn: kotlin.String? = null
        /**
         * The content of the custom vocabulary in plain-text format with a table of values. Each row in the table represents a word or a phrase, described with `Phrase`, `IPA`, `SoundsLike`, and `DisplayAs` fields. Separate the fields with TAB characters. For more information, see [Create a custom vocabulary using a table](https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html#create-vocabulary-table).
         */
        public var content: kotlin.String? = null
        /**
         * The reason why the custom vocabulary was not created.
         */
        public var failureReason: kotlin.String? = null
        /**
         * The identifier of the custom vocabulary.
         */
        public var id: kotlin.String? = null
        /**
         * The language code of the vocabulary entries. For a list of languages and their corresponding language codes, see [What is Amazon Transcribe?](https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-whatis.html)
         */
        public var languageCode: aws.sdk.kotlin.services.connect.model.VocabularyLanguageCode? = null
        /**
         * The timestamp when the custom vocabulary was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A unique name of the custom vocabulary.
         */
        public var name: kotlin.String? = null
        /**
         * The current state of the custom vocabulary.
         */
        public var state: aws.sdk.kotlin.services.connect.model.VocabularyState? = null
        /**
         * The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.Vocabulary) : this() {
            this.arn = x.arn
            this.content = x.content
            this.failureReason = x.failureReason
            this.id = x.id
            this.languageCode = x.languageCode
            this.lastModifiedTime = x.lastModifiedTime
            this.name = x.name
            this.state = x.state
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.Vocabulary = Vocabulary(this)

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (id == null) id = ""
            if (languageCode == null) languageCode = VocabularyLanguageCode.SdkUnknown("no value provided")
            if (lastModifiedTime == null) lastModifiedTime = Instant.fromEpochSeconds(0)
            if (name == null) name = ""
            if (state == null) state = VocabularyState.SdkUnknown("no value provided")
            return this
        }
    }
}
