// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about a traffic distribution group.
 */
public class TrafficDistributionGroup private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the traffic distribution group.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The description of the traffic distribution group.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The identifier of the traffic distribution group. This can be the ID or the ARN if the API is being called in the Region where the traffic distribution group was created. The ARN must be provided if the call is from the replicated Region.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The Amazon Resource Name (ARN).
     */
    public val instanceArn: kotlin.String? = builder.instanceArn
    /**
     * Whether this is the default traffic distribution group created during instance replication. The default traffic distribution group cannot be deleted by the `DeleteTrafficDistributionGroup` API. The default traffic distribution group is deleted as part of the process for deleting a replica.
     *
     * The `SignInConfig` distribution is available only on a default `TrafficDistributionGroup` (see the `IsDefault` parameter in the [TrafficDistributionGroup](https://docs.aws.amazon.com/connect/latest/APIReference/API_TrafficDistributionGroup.html) data type). If you call `UpdateTrafficDistribution` with a modified `SignInConfig` and a non-default `TrafficDistributionGroup`, an `InvalidRequestException` is returned.
     */
    public val isDefault: kotlin.Boolean = builder.isDefault
    /**
     * The name of the traffic distribution group.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The status of the traffic distribution group.
     * + `CREATION_IN_PROGRESS` means the previous [CreateTrafficDistributionGroup](https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateTrafficDistributionGroup.html) operation is still in progress and has not yet completed.
     * + `ACTIVE` means the previous [CreateTrafficDistributionGroup](https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateTrafficDistributionGroup.html) operation has succeeded.
     * + `CREATION_FAILED` indicates that the previous [CreateTrafficDistributionGroup](https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateTrafficDistributionGroup.html) operation has failed.
     * + `PENDING_DELETION` means the previous [DeleteTrafficDistributionGroup](https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteTrafficDistributionGroup.html) operation is still in progress and has not yet completed.
     * + `DELETION_FAILED` means the previous [DeleteTrafficDistributionGroup](https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteTrafficDistributionGroup.html) operation has failed.
     * + `UPDATE_IN_PROGRESS` means the previous [UpdateTrafficDistribution](https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateTrafficDistribution.html) operation is still in progress and has not yet completed.
     */
    public val status: aws.sdk.kotlin.services.connect.model.TrafficDistributionGroupStatus? = builder.status
    /**
     * The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.TrafficDistributionGroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TrafficDistributionGroup(")
        append("arn=$arn,")
        append("description=$description,")
        append("id=$id,")
        append("instanceArn=$instanceArn,")
        append("isDefault=$isDefault,")
        append("name=$name,")
        append("status=$status,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (instanceArn?.hashCode() ?: 0)
        result = 31 * result + (isDefault.hashCode())
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TrafficDistributionGroup

        if (arn != other.arn) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (instanceArn != other.instanceArn) return false
        if (isDefault != other.isDefault) return false
        if (name != other.name) return false
        if (status != other.status) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.TrafficDistributionGroup = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the traffic distribution group.
         */
        public var arn: kotlin.String? = null
        /**
         * The description of the traffic distribution group.
         */
        public var description: kotlin.String? = null
        /**
         * The identifier of the traffic distribution group. This can be the ID or the ARN if the API is being called in the Region where the traffic distribution group was created. The ARN must be provided if the call is from the replicated Region.
         */
        public var id: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN).
         */
        public var instanceArn: kotlin.String? = null
        /**
         * Whether this is the default traffic distribution group created during instance replication. The default traffic distribution group cannot be deleted by the `DeleteTrafficDistributionGroup` API. The default traffic distribution group is deleted as part of the process for deleting a replica.
         *
         * The `SignInConfig` distribution is available only on a default `TrafficDistributionGroup` (see the `IsDefault` parameter in the [TrafficDistributionGroup](https://docs.aws.amazon.com/connect/latest/APIReference/API_TrafficDistributionGroup.html) data type). If you call `UpdateTrafficDistribution` with a modified `SignInConfig` and a non-default `TrafficDistributionGroup`, an `InvalidRequestException` is returned.
         */
        public var isDefault: kotlin.Boolean = false
        /**
         * The name of the traffic distribution group.
         */
        public var name: kotlin.String? = null
        /**
         * The status of the traffic distribution group.
         * + `CREATION_IN_PROGRESS` means the previous [CreateTrafficDistributionGroup](https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateTrafficDistributionGroup.html) operation is still in progress and has not yet completed.
         * + `ACTIVE` means the previous [CreateTrafficDistributionGroup](https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateTrafficDistributionGroup.html) operation has succeeded.
         * + `CREATION_FAILED` indicates that the previous [CreateTrafficDistributionGroup](https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateTrafficDistributionGroup.html) operation has failed.
         * + `PENDING_DELETION` means the previous [DeleteTrafficDistributionGroup](https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteTrafficDistributionGroup.html) operation is still in progress and has not yet completed.
         * + `DELETION_FAILED` means the previous [DeleteTrafficDistributionGroup](https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteTrafficDistributionGroup.html) operation has failed.
         * + `UPDATE_IN_PROGRESS` means the previous [UpdateTrafficDistribution](https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateTrafficDistribution.html) operation is still in progress and has not yet completed.
         */
        public var status: aws.sdk.kotlin.services.connect.model.TrafficDistributionGroupStatus? = null
        /**
         * The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.TrafficDistributionGroup) : this() {
            this.arn = x.arn
            this.description = x.description
            this.id = x.id
            this.instanceArn = x.instanceArn
            this.isDefault = x.isDefault
            this.name = x.name
            this.status = x.status
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.TrafficDistributionGroup = TrafficDistributionGroup(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
