// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.SdkDsl

public class SendChatIntegrationEventRequest private constructor(builder: Builder) {
    /**
     * Chat system identifier, used in part to uniquely identify chat. This is associated with the Amazon Connect instance and flow to be used to start chats. For SMS, this is the phone number destination of inbound SMS messages represented by an Amazon Pinpoint phone number ARN.
     */
    public val destinationId: kotlin.String? = builder.destinationId
    /**
     * Chat integration event payload
     */
    public val event: aws.sdk.kotlin.services.connect.model.ChatEvent? = builder.event
    /**
     * Contact properties to apply when starting a new chat. If the integration event is handled with an existing chat, this is ignored.
     */
    public val newSessionDetails: aws.sdk.kotlin.services.connect.model.NewSessionDetails? = builder.newSessionDetails
    /**
     * External identifier of chat customer participant, used in part to uniquely identify a chat. For SMS, this is the E164 phone number of the chat customer participant.
     */
    public val sourceId: kotlin.String? = builder.sourceId
    /**
     * Classification of a channel. This is used in part to uniquely identify chat.
     *
     * Valid value: `["connect:sms"]`
     */
    public val subtype: kotlin.String? = builder.subtype

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.SendChatIntegrationEventRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SendChatIntegrationEventRequest(")
        append("destinationId=$destinationId,")
        append("event=$event,")
        append("newSessionDetails=$newSessionDetails,")
        append("sourceId=$sourceId,")
        append("subtype=$subtype")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = destinationId?.hashCode() ?: 0
        result = 31 * result + (event?.hashCode() ?: 0)
        result = 31 * result + (newSessionDetails?.hashCode() ?: 0)
        result = 31 * result + (sourceId?.hashCode() ?: 0)
        result = 31 * result + (subtype?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SendChatIntegrationEventRequest

        if (destinationId != other.destinationId) return false
        if (event != other.event) return false
        if (newSessionDetails != other.newSessionDetails) return false
        if (sourceId != other.sourceId) return false
        if (subtype != other.subtype) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.SendChatIntegrationEventRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Chat system identifier, used in part to uniquely identify chat. This is associated with the Amazon Connect instance and flow to be used to start chats. For SMS, this is the phone number destination of inbound SMS messages represented by an Amazon Pinpoint phone number ARN.
         */
        public var destinationId: kotlin.String? = null
        /**
         * Chat integration event payload
         */
        public var event: aws.sdk.kotlin.services.connect.model.ChatEvent? = null
        /**
         * Contact properties to apply when starting a new chat. If the integration event is handled with an existing chat, this is ignored.
         */
        public var newSessionDetails: aws.sdk.kotlin.services.connect.model.NewSessionDetails? = null
        /**
         * External identifier of chat customer participant, used in part to uniquely identify a chat. For SMS, this is the E164 phone number of the chat customer participant.
         */
        public var sourceId: kotlin.String? = null
        /**
         * Classification of a channel. This is used in part to uniquely identify chat.
         *
         * Valid value: `["connect:sms"]`
         */
        public var subtype: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.SendChatIntegrationEventRequest) : this() {
            this.destinationId = x.destinationId
            this.event = x.event
            this.newSessionDetails = x.newSessionDetails
            this.sourceId = x.sourceId
            this.subtype = x.subtype
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.SendChatIntegrationEventRequest = SendChatIntegrationEventRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.ChatEvent] inside the given [block]
         */
        public fun event(block: aws.sdk.kotlin.services.connect.model.ChatEvent.Builder.() -> kotlin.Unit) {
            this.event = aws.sdk.kotlin.services.connect.model.ChatEvent.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.NewSessionDetails] inside the given [block]
         */
        public fun newSessionDetails(block: aws.sdk.kotlin.services.connect.model.NewSessionDetails.Builder.() -> kotlin.Unit) {
            this.newSessionDetails = aws.sdk.kotlin.services.connect.model.NewSessionDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
