// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A structure of search criteria to be used to return contacts.
 */
public class SearchCriteria private constructor(builder: Builder) {
    /**
     * The agent hierarchy groups of the agent at the time of handling the contact.
     */
    public val agentHierarchyGroups: aws.sdk.kotlin.services.connect.model.AgentHierarchyGroups? = builder.agentHierarchyGroups
    /**
     * The identifiers of agents who handled the contacts.
     */
    public val agentIds: List<String>? = builder.agentIds
    /**
     * The list of channels associated with contacts.
     */
    public val channels: List<Channel>? = builder.channels
    /**
     * Search criteria based on analysis outputs from Amazon Connect Contact Lens.
     */
    public val contactAnalysis: aws.sdk.kotlin.services.connect.model.ContactAnalysis? = builder.contactAnalysis
    /**
     * The list of initiation methods associated with contacts.
     */
    public val initiationMethods: List<ContactInitiationMethod>? = builder.initiationMethods
    /**
     * The list of queue IDs associated with contacts.
     */
    public val queueIds: List<String>? = builder.queueIds
    /**
     * The search criteria based on user-defined contact attributes that have been configured for contact search. For more information, see [Search by customer contact attributes](https://docs.aws.amazon.com/connect/latest/adminguide/search-custom-attributes.html) in the *Amazon Connect Administrator Guide*.
     *
     * To use `SearchableContactAttributes` in a search request, the `GetContactAttributes` action is required to perform an API request. For more information, see [https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonconnect.html#amazonconnect-actions-as-permissions](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonconnect.html#amazonconnect-actions-as-permissions)Actions defined by Amazon Connect.
     */
    public val searchableContactAttributes: aws.sdk.kotlin.services.connect.model.SearchableContactAttributes? = builder.searchableContactAttributes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.SearchCriteria = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SearchCriteria(")
        append("agentHierarchyGroups=$agentHierarchyGroups,")
        append("agentIds=$agentIds,")
        append("channels=$channels,")
        append("contactAnalysis=$contactAnalysis,")
        append("initiationMethods=$initiationMethods,")
        append("queueIds=$queueIds,")
        append("searchableContactAttributes=$searchableContactAttributes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = agentHierarchyGroups?.hashCode() ?: 0
        result = 31 * result + (agentIds?.hashCode() ?: 0)
        result = 31 * result + (channels?.hashCode() ?: 0)
        result = 31 * result + (contactAnalysis?.hashCode() ?: 0)
        result = 31 * result + (initiationMethods?.hashCode() ?: 0)
        result = 31 * result + (queueIds?.hashCode() ?: 0)
        result = 31 * result + (searchableContactAttributes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SearchCriteria

        if (agentHierarchyGroups != other.agentHierarchyGroups) return false
        if (agentIds != other.agentIds) return false
        if (channels != other.channels) return false
        if (contactAnalysis != other.contactAnalysis) return false
        if (initiationMethods != other.initiationMethods) return false
        if (queueIds != other.queueIds) return false
        if (searchableContactAttributes != other.searchableContactAttributes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.SearchCriteria = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The agent hierarchy groups of the agent at the time of handling the contact.
         */
        public var agentHierarchyGroups: aws.sdk.kotlin.services.connect.model.AgentHierarchyGroups? = null
        /**
         * The identifiers of agents who handled the contacts.
         */
        public var agentIds: List<String>? = null
        /**
         * The list of channels associated with contacts.
         */
        public var channels: List<Channel>? = null
        /**
         * Search criteria based on analysis outputs from Amazon Connect Contact Lens.
         */
        public var contactAnalysis: aws.sdk.kotlin.services.connect.model.ContactAnalysis? = null
        /**
         * The list of initiation methods associated with contacts.
         */
        public var initiationMethods: List<ContactInitiationMethod>? = null
        /**
         * The list of queue IDs associated with contacts.
         */
        public var queueIds: List<String>? = null
        /**
         * The search criteria based on user-defined contact attributes that have been configured for contact search. For more information, see [Search by customer contact attributes](https://docs.aws.amazon.com/connect/latest/adminguide/search-custom-attributes.html) in the *Amazon Connect Administrator Guide*.
         *
         * To use `SearchableContactAttributes` in a search request, the `GetContactAttributes` action is required to perform an API request. For more information, see [https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonconnect.html#amazonconnect-actions-as-permissions](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonconnect.html#amazonconnect-actions-as-permissions)Actions defined by Amazon Connect.
         */
        public var searchableContactAttributes: aws.sdk.kotlin.services.connect.model.SearchableContactAttributes? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.SearchCriteria) : this() {
            this.agentHierarchyGroups = x.agentHierarchyGroups
            this.agentIds = x.agentIds
            this.channels = x.channels
            this.contactAnalysis = x.contactAnalysis
            this.initiationMethods = x.initiationMethods
            this.queueIds = x.queueIds
            this.searchableContactAttributes = x.searchableContactAttributes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.SearchCriteria = SearchCriteria(this)

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.AgentHierarchyGroups] inside the given [block]
         */
        public fun agentHierarchyGroups(block: aws.sdk.kotlin.services.connect.model.AgentHierarchyGroups.Builder.() -> kotlin.Unit) {
            this.agentHierarchyGroups = aws.sdk.kotlin.services.connect.model.AgentHierarchyGroups.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.ContactAnalysis] inside the given [block]
         */
        public fun contactAnalysis(block: aws.sdk.kotlin.services.connect.model.ContactAnalysis.Builder.() -> kotlin.Unit) {
            this.contactAnalysis = aws.sdk.kotlin.services.connect.model.ContactAnalysis.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.SearchableContactAttributes] inside the given [block]
         */
        public fun searchableContactAttributes(block: aws.sdk.kotlin.services.connect.model.SearchableContactAttributes.Builder.() -> kotlin.Unit) {
            this.searchableContactAttributes = aws.sdk.kotlin.services.connect.model.SearchableContactAttributes.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
