// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about a routing profile.
 */
public class RoutingProfile private constructor(builder: Builder) {
    /**
     * Whether agents with this routing profile will have their routing order calculated based on *time since their last inbound contact* or *longest idle time*.
     */
    public val agentAvailabilityTimer: aws.sdk.kotlin.services.connect.model.AgentAvailabilityTimer? = builder.agentAvailabilityTimer
    /**
     * The identifier of the default outbound queue for this routing profile.
     */
    public val defaultOutboundQueueId: kotlin.String? = builder.defaultOutboundQueueId
    /**
     * The description of the routing profile.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The identifier of the Amazon Connect instance. You can [find the instance ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html) in the Amazon Resource Name (ARN) of the instance.
     */
    public val instanceId: kotlin.String? = builder.instanceId
    /**
     * Whether this a default routing profile.
     */
    public val isDefault: kotlin.Boolean = builder.isDefault
    /**
     * The Amazon Web Services Region where this resource was last modified.
     */
    public val lastModifiedRegion: kotlin.String? = builder.lastModifiedRegion
    /**
     * The timestamp when this resource was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The channels agents can handle in the Contact Control Panel (CCP) for this routing profile.
     */
    public val mediaConcurrencies: List<MediaConcurrency>? = builder.mediaConcurrencies
    /**
     * The name of the routing profile.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The number of associated queues in routing profile.
     */
    public val numberOfAssociatedQueues: kotlin.Long? = builder.numberOfAssociatedQueues
    /**
     * The number of associated users in routing profile.
     */
    public val numberOfAssociatedUsers: kotlin.Long? = builder.numberOfAssociatedUsers
    /**
     * The Amazon Resource Name (ARN) of the routing profile.
     */
    public val routingProfileArn: kotlin.String? = builder.routingProfileArn
    /**
     * The identifier of the routing profile.
     */
    public val routingProfileId: kotlin.String? = builder.routingProfileId
    /**
     * The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.RoutingProfile = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RoutingProfile(")
        append("agentAvailabilityTimer=$agentAvailabilityTimer,")
        append("defaultOutboundQueueId=$defaultOutboundQueueId,")
        append("description=$description,")
        append("instanceId=$instanceId,")
        append("isDefault=$isDefault,")
        append("lastModifiedRegion=$lastModifiedRegion,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("mediaConcurrencies=$mediaConcurrencies,")
        append("name=$name,")
        append("numberOfAssociatedQueues=$numberOfAssociatedQueues,")
        append("numberOfAssociatedUsers=$numberOfAssociatedUsers,")
        append("routingProfileArn=$routingProfileArn,")
        append("routingProfileId=$routingProfileId,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = agentAvailabilityTimer?.hashCode() ?: 0
        result = 31 * result + (defaultOutboundQueueId?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (isDefault.hashCode())
        result = 31 * result + (lastModifiedRegion?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (mediaConcurrencies?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (numberOfAssociatedQueues?.hashCode() ?: 0)
        result = 31 * result + (numberOfAssociatedUsers?.hashCode() ?: 0)
        result = 31 * result + (routingProfileArn?.hashCode() ?: 0)
        result = 31 * result + (routingProfileId?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RoutingProfile

        if (agentAvailabilityTimer != other.agentAvailabilityTimer) return false
        if (defaultOutboundQueueId != other.defaultOutboundQueueId) return false
        if (description != other.description) return false
        if (instanceId != other.instanceId) return false
        if (isDefault != other.isDefault) return false
        if (lastModifiedRegion != other.lastModifiedRegion) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (mediaConcurrencies != other.mediaConcurrencies) return false
        if (name != other.name) return false
        if (numberOfAssociatedQueues != other.numberOfAssociatedQueues) return false
        if (numberOfAssociatedUsers != other.numberOfAssociatedUsers) return false
        if (routingProfileArn != other.routingProfileArn) return false
        if (routingProfileId != other.routingProfileId) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.RoutingProfile = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Whether agents with this routing profile will have their routing order calculated based on *time since their last inbound contact* or *longest idle time*.
         */
        public var agentAvailabilityTimer: aws.sdk.kotlin.services.connect.model.AgentAvailabilityTimer? = null
        /**
         * The identifier of the default outbound queue for this routing profile.
         */
        public var defaultOutboundQueueId: kotlin.String? = null
        /**
         * The description of the routing profile.
         */
        public var description: kotlin.String? = null
        /**
         * The identifier of the Amazon Connect instance. You can [find the instance ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html) in the Amazon Resource Name (ARN) of the instance.
         */
        public var instanceId: kotlin.String? = null
        /**
         * Whether this a default routing profile.
         */
        public var isDefault: kotlin.Boolean = false
        /**
         * The Amazon Web Services Region where this resource was last modified.
         */
        public var lastModifiedRegion: kotlin.String? = null
        /**
         * The timestamp when this resource was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The channels agents can handle in the Contact Control Panel (CCP) for this routing profile.
         */
        public var mediaConcurrencies: List<MediaConcurrency>? = null
        /**
         * The name of the routing profile.
         */
        public var name: kotlin.String? = null
        /**
         * The number of associated queues in routing profile.
         */
        public var numberOfAssociatedQueues: kotlin.Long? = null
        /**
         * The number of associated users in routing profile.
         */
        public var numberOfAssociatedUsers: kotlin.Long? = null
        /**
         * The Amazon Resource Name (ARN) of the routing profile.
         */
        public var routingProfileArn: kotlin.String? = null
        /**
         * The identifier of the routing profile.
         */
        public var routingProfileId: kotlin.String? = null
        /**
         * The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.RoutingProfile) : this() {
            this.agentAvailabilityTimer = x.agentAvailabilityTimer
            this.defaultOutboundQueueId = x.defaultOutboundQueueId
            this.description = x.description
            this.instanceId = x.instanceId
            this.isDefault = x.isDefault
            this.lastModifiedRegion = x.lastModifiedRegion
            this.lastModifiedTime = x.lastModifiedTime
            this.mediaConcurrencies = x.mediaConcurrencies
            this.name = x.name
            this.numberOfAssociatedQueues = x.numberOfAssociatedQueues
            this.numberOfAssociatedUsers = x.numberOfAssociatedUsers
            this.routingProfileArn = x.routingProfileArn
            this.routingProfileId = x.routingProfileId
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.RoutingProfile = RoutingProfile(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
