// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Segment type describing a contact event.
 */
public class RealTimeContactAnalysisSegmentEvent private constructor(builder: Builder) {
    /**
     * The display name of the participant. Can be redacted.
     */
    public val displayName: kotlin.String? = builder.displayName
    /**
     * Type of the event. For example, `application/vnd.amazonaws.connect.event.participant.left`.
     */
    public val eventType: kotlin.String = requireNotNull(builder.eventType) { "A non-null value must be provided for eventType" }
    /**
     * The identifier of the contact event.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The identifier of the participant.
     */
    public val participantId: kotlin.String? = builder.participantId
    /**
     * The role of the participant. For example, is it a customer, agent, or system.
     */
    public val participantRole: aws.sdk.kotlin.services.connect.model.ParticipantRole? = builder.participantRole
    /**
     * Field describing the time of the event. It can have different representations of time.
     */
    public val time: aws.sdk.kotlin.services.connect.model.RealTimeContactAnalysisTimeData? = builder.time

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.RealTimeContactAnalysisSegmentEvent = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RealTimeContactAnalysisSegmentEvent(")
        append("displayName=$displayName,")
        append("eventType=$eventType,")
        append("id=$id,")
        append("participantId=$participantId,")
        append("participantRole=$participantRole,")
        append("time=$time")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = displayName?.hashCode() ?: 0
        result = 31 * result + (eventType.hashCode())
        result = 31 * result + (id.hashCode())
        result = 31 * result + (participantId?.hashCode() ?: 0)
        result = 31 * result + (participantRole?.hashCode() ?: 0)
        result = 31 * result + (time?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RealTimeContactAnalysisSegmentEvent

        if (displayName != other.displayName) return false
        if (eventType != other.eventType) return false
        if (id != other.id) return false
        if (participantId != other.participantId) return false
        if (participantRole != other.participantRole) return false
        if (time != other.time) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.RealTimeContactAnalysisSegmentEvent = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The display name of the participant. Can be redacted.
         */
        public var displayName: kotlin.String? = null
        /**
         * Type of the event. For example, `application/vnd.amazonaws.connect.event.participant.left`.
         */
        public var eventType: kotlin.String? = null
        /**
         * The identifier of the contact event.
         */
        public var id: kotlin.String? = null
        /**
         * The identifier of the participant.
         */
        public var participantId: kotlin.String? = null
        /**
         * The role of the participant. For example, is it a customer, agent, or system.
         */
        public var participantRole: aws.sdk.kotlin.services.connect.model.ParticipantRole? = null
        /**
         * Field describing the time of the event. It can have different representations of time.
         */
        public var time: aws.sdk.kotlin.services.connect.model.RealTimeContactAnalysisTimeData? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.RealTimeContactAnalysisSegmentEvent) : this() {
            this.displayName = x.displayName
            this.eventType = x.eventType
            this.id = x.id
            this.participantId = x.participantId
            this.participantRole = x.participantRole
            this.time = x.time
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.RealTimeContactAnalysisSegmentEvent = RealTimeContactAnalysisSegmentEvent(this)

        internal fun correctErrors(): Builder {
            if (eventType == null) eventType = ""
            if (id == null) id = ""
            return this
        }
    }
}
