// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Object that describes attached file.
 */
public class RealTimeContactAnalysisAttachment private constructor(builder: Builder) {
    /**
     * A unique identifier for the attachment.
     */
    public val attachmentId: kotlin.String = requireNotNull(builder.attachmentId) { "A non-null value must be provided for attachmentId" }
    /**
     * A case-sensitive name of the attachment being uploaded. Can be redacted.
     */
    public val attachmentName: kotlin.String = requireNotNull(builder.attachmentName) { "A non-null value must be provided for attachmentName" }
    /**
     * Describes the MIME file type of the attachment. For a list of supported file types, see [Feature specifications](https://docs.aws.amazon.com/connect/latest/adminguide/feature-limits.html) in the *Amazon Connect Administrator Guide*.
     */
    public val contentType: kotlin.String? = builder.contentType
    /**
     * Status of the attachment.
     */
    public val status: aws.sdk.kotlin.services.connect.model.ArtifactStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.RealTimeContactAnalysisAttachment = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RealTimeContactAnalysisAttachment(")
        append("attachmentId=$attachmentId,")
        append("attachmentName=$attachmentName,")
        append("contentType=$contentType,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attachmentId.hashCode()
        result = 31 * result + (attachmentName.hashCode())
        result = 31 * result + (contentType?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RealTimeContactAnalysisAttachment

        if (attachmentId != other.attachmentId) return false
        if (attachmentName != other.attachmentName) return false
        if (contentType != other.contentType) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.RealTimeContactAnalysisAttachment = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A unique identifier for the attachment.
         */
        public var attachmentId: kotlin.String? = null
        /**
         * A case-sensitive name of the attachment being uploaded. Can be redacted.
         */
        public var attachmentName: kotlin.String? = null
        /**
         * Describes the MIME file type of the attachment. For a list of supported file types, see [Feature specifications](https://docs.aws.amazon.com/connect/latest/adminguide/feature-limits.html) in the *Amazon Connect Administrator Guide*.
         */
        public var contentType: kotlin.String? = null
        /**
         * Status of the attachment.
         */
        public var status: aws.sdk.kotlin.services.connect.model.ArtifactStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.RealTimeContactAnalysisAttachment) : this() {
            this.attachmentId = x.attachmentId
            this.attachmentName = x.attachmentName
            this.contentType = x.contentType
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.RealTimeContactAnalysisAttachment = RealTimeContactAnalysisAttachment(this)

        internal fun correctErrors(): Builder {
            if (attachmentId == null) attachmentId = ""
            if (attachmentName == null) attachmentName = ""
            return this
        }
    }
}
