// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ListPhoneNumbersV2Request private constructor(builder: Builder) {
    /**
     * The identifier of the Amazon Connect instance that phone numbers are claimed to. You can [find the instance ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html) in the Amazon Resource Name (ARN) of the instance. If both `TargetArn` and `InstanceId` are not provided, this API lists numbers claimed to all the Amazon Connect instances belonging to your account in the same AWS Region as the request.
     */
    public val instanceId: kotlin.String? = builder.instanceId
    /**
     * The maximum number of results to return per page.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The ISO country code.
     */
    public val phoneNumberCountryCodes: List<PhoneNumberCountryCode>? = builder.phoneNumberCountryCodes
    /**
     * The prefix of the phone number. If provided, it must contain `+` as part of the country code.
     */
    public val phoneNumberPrefix: kotlin.String? = builder.phoneNumberPrefix
    /**
     * The type of phone number.
     */
    public val phoneNumberTypes: List<PhoneNumberType>? = builder.phoneNumberTypes
    /**
     * The Amazon Resource Name (ARN) for Amazon Connect instances or traffic distribution groups that phone number inbound traffic is routed through. If both `TargetArn` and `InstanceId` input are not provided, this API lists numbers claimed to all the Amazon Connect instances belonging to your account in the same Amazon Web Services Region as the request.
     */
    public val targetArn: kotlin.String? = builder.targetArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.ListPhoneNumbersV2Request = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListPhoneNumbersV2Request(")
        append("instanceId=$instanceId,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("phoneNumberCountryCodes=$phoneNumberCountryCodes,")
        append("phoneNumberPrefix=$phoneNumberPrefix,")
        append("phoneNumberTypes=$phoneNumberTypes,")
        append("targetArn=$targetArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = instanceId?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (phoneNumberCountryCodes?.hashCode() ?: 0)
        result = 31 * result + (phoneNumberPrefix?.hashCode() ?: 0)
        result = 31 * result + (phoneNumberTypes?.hashCode() ?: 0)
        result = 31 * result + (targetArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListPhoneNumbersV2Request

        if (instanceId != other.instanceId) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (phoneNumberCountryCodes != other.phoneNumberCountryCodes) return false
        if (phoneNumberPrefix != other.phoneNumberPrefix) return false
        if (phoneNumberTypes != other.phoneNumberTypes) return false
        if (targetArn != other.targetArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.ListPhoneNumbersV2Request = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier of the Amazon Connect instance that phone numbers are claimed to. You can [find the instance ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html) in the Amazon Resource Name (ARN) of the instance. If both `TargetArn` and `InstanceId` are not provided, this API lists numbers claimed to all the Amazon Connect instances belonging to your account in the same AWS Region as the request.
         */
        public var instanceId: kotlin.String? = null
        /**
         * The maximum number of results to return per page.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The ISO country code.
         */
        public var phoneNumberCountryCodes: List<PhoneNumberCountryCode>? = null
        /**
         * The prefix of the phone number. If provided, it must contain `+` as part of the country code.
         */
        public var phoneNumberPrefix: kotlin.String? = null
        /**
         * The type of phone number.
         */
        public var phoneNumberTypes: List<PhoneNumberType>? = null
        /**
         * The Amazon Resource Name (ARN) for Amazon Connect instances or traffic distribution groups that phone number inbound traffic is routed through. If both `TargetArn` and `InstanceId` input are not provided, this API lists numbers claimed to all the Amazon Connect instances belonging to your account in the same Amazon Web Services Region as the request.
         */
        public var targetArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.ListPhoneNumbersV2Request) : this() {
            this.instanceId = x.instanceId
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.phoneNumberCountryCodes = x.phoneNumberCountryCodes
            this.phoneNumberPrefix = x.phoneNumberPrefix
            this.phoneNumberTypes = x.phoneNumberTypes
            this.targetArn = x.targetArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.ListPhoneNumbersV2Request = ListPhoneNumbersV2Request(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
