// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Metadata information about a contact evaluation.
 */
public class EvaluationMetadata private constructor(builder: Builder) {
    /**
     * The identifier of the agent who performed the contact.
     */
    public val contactAgentId: kotlin.String? = builder.contactAgentId
    /**
     * The identifier of the contact in this instance of Amazon Connect.
     */
    public val contactId: kotlin.String = requireNotNull(builder.contactId) { "A non-null value must be provided for contactId" }
    /**
     * The Amazon Resource Name (ARN) of the user who last updated the evaluation.
     */
    public val evaluatorArn: kotlin.String = requireNotNull(builder.evaluatorArn) { "A non-null value must be provided for evaluatorArn" }
    /**
     * The overall score of the contact evaluation.
     */
    public val score: aws.sdk.kotlin.services.connect.model.EvaluationScore? = builder.score

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.EvaluationMetadata = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EvaluationMetadata(")
        append("contactAgentId=$contactAgentId,")
        append("contactId=$contactId,")
        append("evaluatorArn=$evaluatorArn,")
        append("score=$score")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = contactAgentId?.hashCode() ?: 0
        result = 31 * result + (contactId.hashCode())
        result = 31 * result + (evaluatorArn.hashCode())
        result = 31 * result + (score?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EvaluationMetadata

        if (contactAgentId != other.contactAgentId) return false
        if (contactId != other.contactId) return false
        if (evaluatorArn != other.evaluatorArn) return false
        if (score != other.score) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.EvaluationMetadata = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier of the agent who performed the contact.
         */
        public var contactAgentId: kotlin.String? = null
        /**
         * The identifier of the contact in this instance of Amazon Connect.
         */
        public var contactId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the user who last updated the evaluation.
         */
        public var evaluatorArn: kotlin.String? = null
        /**
         * The overall score of the contact evaluation.
         */
        public var score: aws.sdk.kotlin.services.connect.model.EvaluationScore? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.EvaluationMetadata) : this() {
            this.contactAgentId = x.contactAgentId
            this.contactId = x.contactId
            this.evaluatorArn = x.evaluatorArn
            this.score = x.score
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.EvaluationMetadata = EvaluationMetadata(this)

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.EvaluationScore] inside the given [block]
         */
        public fun score(block: aws.sdk.kotlin.services.connect.model.EvaluationScore.Builder.() -> kotlin.Unit) {
            this.score = aws.sdk.kotlin.services.connect.model.EvaluationScore.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (contactId == null) contactId = ""
            if (evaluatorArn == null) evaluatorArn = ""
            return this
        }
    }
}
