// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Summary information about an evaluation form.
 */
public class EvaluationFormVersionSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the user who created the evaluation form.
     */
    public val createdBy: kotlin.String = requireNotNull(builder.createdBy) { "A non-null value must be provided for createdBy" }
    /**
     * The timestamp for when the evaluation form was created.
     */
    public val createdTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdTime) { "A non-null value must be provided for createdTime" }
    /**
     * The Amazon Resource Name (ARN) for the evaluation form resource.
     */
    public val evaluationFormArn: kotlin.String = requireNotNull(builder.evaluationFormArn) { "A non-null value must be provided for evaluationFormArn" }
    /**
     * The unique identifier for the evaluation form.
     */
    public val evaluationFormId: kotlin.String = requireNotNull(builder.evaluationFormId) { "A non-null value must be provided for evaluationFormId" }
    /**
     * A version of the evaluation form.
     */
    public val evaluationFormVersion: kotlin.Int = builder.evaluationFormVersion
    /**
     * The Amazon Resource Name (ARN) of the user who last updated the evaluation form.
     */
    public val lastModifiedBy: kotlin.String = requireNotNull(builder.lastModifiedBy) { "A non-null value must be provided for lastModifiedBy" }
    /**
     * The timestamp for when the evaluation form was last updated.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastModifiedTime) { "A non-null value must be provided for lastModifiedTime" }
    /**
     * The flag indicating whether the evaluation form is locked for changes.
     */
    public val locked: kotlin.Boolean = builder.locked
    /**
     * The status of the evaluation form.
     */
    public val status: aws.sdk.kotlin.services.connect.model.EvaluationFormVersionStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.EvaluationFormVersionSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EvaluationFormVersionSummary(")
        append("createdBy=$createdBy,")
        append("createdTime=$createdTime,")
        append("evaluationFormArn=$evaluationFormArn,")
        append("evaluationFormId=$evaluationFormId,")
        append("evaluationFormVersion=$evaluationFormVersion,")
        append("lastModifiedBy=$lastModifiedBy,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("locked=$locked,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdBy.hashCode()
        result = 31 * result + (createdTime.hashCode())
        result = 31 * result + (evaluationFormArn.hashCode())
        result = 31 * result + (evaluationFormId.hashCode())
        result = 31 * result + (evaluationFormVersion)
        result = 31 * result + (lastModifiedBy.hashCode())
        result = 31 * result + (lastModifiedTime.hashCode())
        result = 31 * result + (locked.hashCode())
        result = 31 * result + (status.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EvaluationFormVersionSummary

        if (createdBy != other.createdBy) return false
        if (createdTime != other.createdTime) return false
        if (evaluationFormArn != other.evaluationFormArn) return false
        if (evaluationFormId != other.evaluationFormId) return false
        if (evaluationFormVersion != other.evaluationFormVersion) return false
        if (lastModifiedBy != other.lastModifiedBy) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (locked != other.locked) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.EvaluationFormVersionSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the user who created the evaluation form.
         */
        public var createdBy: kotlin.String? = null
        /**
         * The timestamp for when the evaluation form was created.
         */
        public var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) for the evaluation form resource.
         */
        public var evaluationFormArn: kotlin.String? = null
        /**
         * The unique identifier for the evaluation form.
         */
        public var evaluationFormId: kotlin.String? = null
        /**
         * A version of the evaluation form.
         */
        public var evaluationFormVersion: kotlin.Int = 0
        /**
         * The Amazon Resource Name (ARN) of the user who last updated the evaluation form.
         */
        public var lastModifiedBy: kotlin.String? = null
        /**
         * The timestamp for when the evaluation form was last updated.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The flag indicating whether the evaluation form is locked for changes.
         */
        public var locked: kotlin.Boolean = false
        /**
         * The status of the evaluation form.
         */
        public var status: aws.sdk.kotlin.services.connect.model.EvaluationFormVersionStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.EvaluationFormVersionSummary) : this() {
            this.createdBy = x.createdBy
            this.createdTime = x.createdTime
            this.evaluationFormArn = x.evaluationFormArn
            this.evaluationFormId = x.evaluationFormId
            this.evaluationFormVersion = x.evaluationFormVersion
            this.lastModifiedBy = x.lastModifiedBy
            this.lastModifiedTime = x.lastModifiedTime
            this.locked = x.locked
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.EvaluationFormVersionSummary = EvaluationFormVersionSummary(this)

        internal fun correctErrors(): Builder {
            if (createdBy == null) createdBy = ""
            if (createdTime == null) createdTime = Instant.fromEpochSeconds(0)
            if (evaluationFormArn == null) evaluationFormArn = ""
            if (evaluationFormId == null) evaluationFormId = ""
            if (lastModifiedBy == null) lastModifiedBy = ""
            if (lastModifiedTime == null) lastModifiedTime = Instant.fromEpochSeconds(0)
            if (status == null) status = EvaluationFormVersionStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
